/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.query.SearchDatabase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.rest.SearchMapping;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.SortDirection;

@Named
public class SqlSearchSortUtil
extends ComponentSupport {
    public static final String JSON_PATH_FORMAT = "%s #> '{%s}'";
    public static final String MAVEN_2 = "maven2";
    public static final String DOCKER_LAYER_ANCESTRY = "layerAncestry";
    public static final String DOCKER_CONTENT_DIGEST = "content_digest";
    private final SearchDatabase searchDatabase;
    private final Map<String, SearchField> aliasToColumn;

    @Inject
    public SqlSearchSortUtil(SearchDatabase searchDatabase, List<SearchMappings> searchMappings) {
        this.searchDatabase = (SearchDatabase)Preconditions.checkNotNull((Object)searchDatabase);
        this.aliasToColumn = ((List)Preconditions.checkNotNull(searchMappings)).stream().map(SearchMappings::get).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false)).collect(Collectors.toMap(mapping -> SqlSearchSortUtil.getAlias(mapping.getAlias()), SearchMapping::getField));
    }

    public Optional<String> getSortExpression(@Nullable String sortAttribute) {
        Optional<String> sortAlias = Optional.ofNullable(sortAttribute).flatMap(this::isAttributesField);
        Optional sortColumn = sortAlias.map(this.aliasToColumn::get).flatMap(this.searchDatabase::getSortColumn);
        return sortColumn.filter("attributes"::equals).map(this.sortExpressionForAttributesColumn(sortAlias)).orElse(sortColumn);
    }

    public Optional<SortDirection> getSortDirection(@Nullable String sortAttribute) {
        return Optional.ofNullable(sortAttribute).flatMap(this::isAttributesField).map(this.aliasToColumn::get).map(SearchField::direction);
    }

    private Function<String, Optional<String>> sortExpressionForAttributesColumn(Optional<String> sortAlias) {
        return column -> sortAlias.map(alias -> alias.replace('.', ',')).map(alias -> String.format(JSON_PATH_FORMAT, column, alias));
    }

    private Optional<String> isAttributesField(String value) {
        return StringUtils.startsWith((CharSequence)value, (CharSequence)"assets.attributes.") || StringUtils.startsWith((CharSequence)value, (CharSequence)"attributes.") ? this.extractSuffix(value) : Optional.of(value);
    }

    private Optional<String> extractSuffix(@Nullable String sortAttribute) {
        if (sortAttribute == null) {
            return Optional.empty();
        }
        int prefixIndex = StringUtils.indexOf((CharSequence)sortAttribute, (CharSequence)"attributes");
        if (prefixIndex >= 0) {
            int beginIndex = prefixIndex + "attributes.".length();
            return Optional.of(StringUtils.substring((String)sortAttribute, (int)beginIndex));
        }
        return Optional.empty();
    }

    protected static String getAlias(String alias) {
        if (StringUtils.startsWith((CharSequence)alias, (CharSequence)"maven.")) {
            return StringUtils.replace((String)alias, (String)"maven", (String)MAVEN_2);
        }
        if (StringUtils.equals((CharSequence)alias, (CharSequence)"docker.layerId")) {
            return StringUtils.replace((String)alias, (String)"layerId", (String)DOCKER_LAYER_ANCESTRY);
        }
        if (StringUtils.equals((CharSequence)alias, (CharSequence)"docker.contentDigest")) {
            return StringUtils.replace((String)alias, (String)"contentDigest", (String)DOCKER_CONTENT_DIGEST);
        }
        return alias;
    }
}

