/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.distributed.internal.search.sql.query.ExpressionBuilder;
import com.sonatype.nexus.distributed.internal.search.sql.query.SearchConditionFactory;
import com.sonatype.nexus.distributed.internal.search.sql.query.SqlSearchQueryCondition;
import com.sonatype.nexus.distributed.internal.search.sql.query.SqlSearchSortUtil;
import com.sonatype.nexus.distributed.internal.search.sql.query.postgres.PostgresFulltextSearchConditionBuilder;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.SqlSearchPermissionException;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.UnknownRepositoriesException;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchResponse;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SortDirection;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SearchResult;
import org.sonatype.nexus.repository.search.sql.SqlSearchResultDecorator;

@Named
@Singleton
public class SqlSearchService
extends ComponentSupport
implements SearchService {
    private static final String SEARCH_ANY_SYMBOLS = "*";
    private final SearchStore searchStore;
    private final ExpressionBuilder expressionBuilder;
    private final SearchConditionFactory queryFactory;
    private final Map<String, FormatStoreManager> formatStoreManagersByFormat;
    private final SqlSearchSortUtil sqlSearchSortUtil;
    private final Set<SqlSearchResultDecorator> decorators;

    @Inject
    public SqlSearchService(SearchStore searchStore, SqlSearchSortUtil sqlSearchSortUtil, Map<String, FormatStoreManager> formatStoreManagersByFormat, ExpressionBuilder expressionBuilder, SearchConditionFactory queryFactory, Set<SqlSearchResultDecorator> decorators) {
        this.searchStore = (SearchStore)((Object)Preconditions.checkNotNull((Object)((Object)searchStore)));
        this.expressionBuilder = (ExpressionBuilder)((Object)Preconditions.checkNotNull((Object)((Object)expressionBuilder)));
        this.queryFactory = (SearchConditionFactory)Preconditions.checkNotNull((Object)queryFactory);
        this.formatStoreManagersByFormat = (Map)Preconditions.checkNotNull(formatStoreManagersByFormat);
        this.sqlSearchSortUtil = (SqlSearchSortUtil)((Object)Preconditions.checkNotNull((Object)((Object)sqlSearchSortUtil)));
        this.decorators = (Set)Preconditions.checkNotNull(decorators);
    }

    public SearchResponse search(SearchRequest searchRequest) {
        ComponentSearchResultPage searchResultPage = this.searchComponents(searchRequest);
        SearchResponse response = new SearchResponse();
        response.setSearchResults(searchResultPage.componentSearchResults);
        response.setTotalHits(Long.valueOf(searchResultPage.componentSearchResults.size()));
        searchResultPage.nextOffset.map(String::valueOf).ifPresent(arg_0 -> ((SearchResponse)response).setContinuationToken(arg_0));
        return response;
    }

    public Iterable<ComponentSearchResult> browse(SearchRequest searchRequest) {
        return this.searchComponents(searchRequest).componentSearchResults;
    }

    public long count(SearchRequest searchRequest) {
        try {
            SqlSearchQueryCondition queryCondition = this.getSqlSearchQueryCondition(searchRequest);
            return this.searchStore.count(queryCondition);
        }
        catch (SqlSearchPermissionException | UnknownRepositoriesException e) {
            this.log.error(e.getMessage());
            return 0L;
        }
    }

    private ComponentSearchResultPage searchComponents(SearchRequest searchRequest) {
        try {
            SqlSearchQueryCondition queryCondition = this.getSqlSearchQueryCondition(searchRequest);
            this.log.debug("Query: {}", (Object)queryCondition);
            return this.doSearch(searchRequest, queryCondition);
        }
        catch (SqlSearchPermissionException | UnknownRepositoriesException e) {
            this.log.error(e.getMessage());
            return ComponentSearchResultPage.empty();
        }
    }

    @Nullable
    private SqlSearchQueryCondition getSqlSearchQueryCondition(SearchRequest searchRequest) {
        return this.expressionBuilder.from(searchRequest).map(this.queryFactory::build).orElse(null);
    }

    private AssetStore<?> getAssetStore(String format) {
        FormatStoreManager formatStoreManager = this.formatStoreManagersByFormat.get(format);
        return formatStoreManager.assetStore("nexus");
    }

    private ComponentSearchResultPage doSearch(SearchRequest searchRequest, @Nullable SqlSearchQueryCondition queryCondition) {
        Integer offset = SqlSearchService.offsetFromToken(searchRequest.getContinuationToken()).orElseGet(() -> ((SearchRequest)searchRequest).getOffset());
        Optional<Integer> nextOffset = Optional.empty();
        if (offset == null) {
            offset = 0;
        } else if (offset < 0) {
            throw new BadRequestException("Continuation token must be positive");
        }
        OrderBy orderBy = this.getOrderBy(searchRequest);
        Collection searchResults = this.searchStore.searchComponents(searchRequest.getLimit(), offset, queryCondition, orderBy.columnName, orderBy.direction);
        if (searchResults.isEmpty()) {
            return ComponentSearchResultPage.empty();
        }
        if ((searchResults = this.maybeFilterSearchResults(searchResults, offset, searchRequest, queryCondition)).size() > searchRequest.getLimit()) {
            nextOffset = Optional.of(offset + searchResults.size());
            searchResults = searchResults.stream().limit(searchRequest.getLimit()).collect(Collectors.toList());
        } else if (searchResults.size() == searchRequest.getLimit()) {
            nextOffset = Optional.of(offset + searchRequest.getLimit());
        }
        Map<String, List<AssetInfo>> componentIdToAsset = this.getAssetsForComponents(searchResults, searchRequest.isIncludeAssets());
        ArrayList<ComponentSearchResult> componentSearchResults = new ArrayList<ComponentSearchResult>(searchResults.size());
        for (SearchResult component : searchResults) {
            String repositoryName = component.repositoryName();
            ComponentSearchResult componentSearchResult = this.buildComponentSearchResult(component);
            if (searchRequest.isIncludeAssets()) {
                List<AssetInfo> assets = componentIdToAsset.get(this.getFormatComponentKey(component.format(), component.componentId()));
                assets.stream().map(asset -> this.buildAssetSearch((AssetInfo)asset, repositoryName, component)).forEach(arg_0 -> ((ComponentSearchResult)componentSearchResult).addAsset(arg_0));
            }
            componentSearchResults.add(componentSearchResult);
        }
        return new ComponentSearchResultPage(nextOffset, componentSearchResults);
    }

    private OrderBy getOrderBy(SearchRequest searchRequest) {
        String sortColumnName = this.sqlSearchSortUtil.getSortExpression(searchRequest.getSortField()).orElse(null);
        SortDirection sortDirection = searchRequest.getSortDirection();
        if (sortDirection == null) {
            sortDirection = this.sqlSearchSortUtil.getSortDirection(searchRequest.getSortField()).orElse(null);
        }
        return new OrderBy(sortColumnName, sortDirection);
    }

    private Collection<SearchResult> maybeFilterSearchResults(Collection<SearchResult> searchResults, int offset, SearchRequest searchRequest, SqlSearchQueryCondition queryCondition) {
        Optional<SearchFilter> keywordRegexFilter = searchRequest.getSearchFilters().stream().filter(filter -> "keyword".equals(filter.getProperty()) && filter.getValue().contains(SEARCH_ANY_SYMBOLS)).findFirst();
        if (keywordRegexFilter.isPresent()) {
            String regex = keywordRegexFilter.get().getValue().replace(SEARCH_ANY_SYMBOLS, ".*");
            Pattern searchPattern = Pattern.compile(regex, 2);
            Collection<SearchResult> filteredResults = SqlSearchService.filterSearchResults(searchResults, searchPattern);
            int nextOffset = offset + searchResults.size();
            this.fetchMoreResults(nextOffset, searchRequest, queryCondition, searchPattern, filteredResults);
            return filteredResults;
        }
        keywordRegexFilter = searchRequest.getSearchFilters().stream().filter(filter -> "keyword".equals(filter.getProperty()) && PostgresFulltextSearchConditionBuilder.isRemoveLastWords(filter.getValue())).findFirst();
        if (keywordRegexFilter.isPresent()) {
            String regex = keywordRegexFilter.get().getValue();
            Pattern searchPattern = Pattern.compile(regex, 2);
            Collection<SearchResult> filteredResults = SqlSearchService.filterSearchResults(searchResults, searchPattern);
            int nextOffset = offset + searchResults.size();
            this.fetchMoreResults(nextOffset, searchRequest, queryCondition, searchPattern, filteredResults);
            return filteredResults;
        }
        return searchResults;
    }

    private static Collection<SearchResult> filterSearchResults(Collection<SearchResult> searchResults, Pattern searchPattern) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (SearchResult searchResult : searchResults) {
            boolean matched = searchPattern.matcher(searchResult.componentName()).find();
            matched |= searchPattern.matcher(searchResult.format()).find();
            matched |= searchPattern.matcher(searchResult.version()).find();
            matched |= searchPattern.matcher(searchResult.normalisedVersion()).find();
            matched |= searchPattern.matcher(searchResult.repositoryName()).find();
            matched |= searchPattern.matcher(searchResult.namespace()).find();
            if (!(matched |= searchPattern.matcher(searchResult.attributes().toString()).find())) continue;
            results.add(searchResult);
        }
        return results;
    }

    private void fetchMoreResults(int offset, SearchRequest searchRequest, SqlSearchQueryCondition queryCondition, Pattern searchPattern, Collection<SearchResult> filteredSearchResults) {
        int nextOffset = offset;
        while (filteredSearchResults.size() < searchRequest.getLimit()) {
            OrderBy orderBy = this.getOrderBy(searchRequest);
            Collection<SearchResult> results = this.searchStore.searchComponents(searchRequest.getLimit(), nextOffset, queryCondition, orderBy.columnName, orderBy.direction);
            if (results.isEmpty()) break;
            nextOffset += results.size();
            filteredSearchResults.addAll(SqlSearchService.filterSearchResults(results, searchPattern));
        }
    }

    private static Optional<Integer> offsetFromToken(@Nullable String continuationToken) {
        try {
            return Optional.ofNullable(continuationToken).map(Integer::parseInt);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadRequestException("Continuation token should be a number");
        }
    }

    private String getFormatComponentKey(String format, Integer componentId) {
        return String.valueOf(format) + componentId;
    }

    private Map<String, List<AssetInfo>> getAssetsForComponents(Collection<SearchResult> searchResults, boolean includeAssets) {
        if (!includeAssets) {
            return Collections.emptyMap();
        }
        HashMap<String, List<AssetInfo>> componentIdToAsset = new HashMap<String, List<AssetInfo>>();
        HashMap<String, ArrayList> componentIdsByFormat = new HashMap<String, ArrayList>();
        for (SearchResult searchResult : searchResults) {
            if (componentIdsByFormat.containsKey(searchResult.format())) {
                ((List)componentIdsByFormat.get(searchResult.format())).add(searchResult.componentId());
                continue;
            }
            ArrayList componentIds = Lists.newArrayList((Object[])new Integer[]{searchResult.componentId()});
            componentIdsByFormat.put(searchResult.format(), componentIds);
        }
        for (Map.Entry entry : componentIdsByFormat.entrySet()) {
            AssetStore<?> assetStore = this.getAssetStore((String)entry.getKey());
            HashSet componentIds = new HashSet((Collection)entry.getValue());
            componentIdToAsset.putAll(assetStore.findByComponentIds(componentIds).stream().collect(Collectors.groupingBy(assetInfo -> this.getFormatComponentKey((String)formatComponentIds.getKey(), assetInfo.componentId()))));
        }
        return componentIdToAsset;
    }

    private ComponentSearchResult buildComponentSearchResult(SearchResult searchResult) {
        ComponentSearchResult componentSearchResult = new ComponentSearchResult();
        componentSearchResult.setId(InternalIds.toExternalId((int)searchResult.componentId()).getValue());
        componentSearchResult.setFormat(searchResult.format());
        componentSearchResult.setRepositoryName(searchResult.repositoryName());
        componentSearchResult.setName(searchResult.componentName());
        componentSearchResult.setGroup(searchResult.namespace());
        componentSearchResult.setVersion(searchResult.version());
        componentSearchResult.setLastModified(searchResult.lastModified());
        this.decorators.forEach(decorator -> decorator.updateComponent(componentSearchResult, searchResult));
        return componentSearchResult;
    }

    private AssetSearchResult buildAssetSearch(AssetInfo asset, String repositoryName, SearchResult componentInfo) {
        AssetSearchResult searchResult = new AssetSearchResult();
        searchResult.setId(InternalIds.toExternalId((int)asset.assetId()).getValue());
        searchResult.setPath(asset.path());
        searchResult.setRepository(repositoryName);
        searchResult.setFormat(componentInfo.format());
        searchResult.setLastModified(Date.from(asset.blobCreated().toInstant()));
        searchResult.setAttributes(asset.attributes().backing());
        searchResult.getAttributes().put("checksum", asset.checksums());
        searchResult.setContentType(asset.contentType());
        searchResult.setChecksum(asset.checksums());
        searchResult.setUploader(asset.createdBy());
        searchResult.setUploaderIp(asset.createdByIp());
        searchResult.setFileSize(asset.blobSize());
        Optional.ofNullable(asset.lastDownloaded()).ifPresent(when -> searchResult.setLastDownloaded(Date.from(when.toInstant())));
        return searchResult;
    }

    private static class ComponentSearchResultPage {
        private final Optional<Integer> nextOffset;
        private final List<ComponentSearchResult> componentSearchResults;

        public ComponentSearchResultPage(Optional<Integer> nextOffset, List<ComponentSearchResult> componentSearchResults) {
            this.nextOffset = nextOffset;
            this.componentSearchResults = (List)Preconditions.checkNotNull(componentSearchResults);
        }

        private static ComponentSearchResultPage empty() {
            return new ComponentSearchResultPage(Optional.empty(), Collections.emptyList());
        }
    }

    private static class OrderBy {
        public final String columnName;
        public final SortDirection direction;

        public OrderBy(@Nullable String columnName, @Nullable SortDirection direction) {
            this.columnName = columnName;
            this.direction = direction;
        }
    }
}

