/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query;

import java.util.Objects;

public enum SearchViewColumns {
    COMPONENT_ID("componentId"),
    NAMESPACE("namespace"),
    SEARCH_COMPONENT_NAME("componentName"),
    VERSION("version"),
    NORMALISED_VERSION("normalised_version"),
    REPOSITORY_NAME("repositoryName"),
    FORMAT("format");

    private final String name;

    private SearchViewColumns(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static SearchViewColumns fromSortFieldName(String name) {
        if (Objects.isNull(name)) {
            return COMPONENT_ID;
        }
        switch (name) {
            case "group": {
                return NAMESPACE;
            }
            case "id": {
                return COMPONENT_ID;
            }
            case "name": {
                return SEARCH_COMPONENT_NAME;
            }
            case "version": {
                return NORMALISED_VERSION;
            }
        }
        return COMPONENT_ID;
    }
}

