/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query;

import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.rest.sql.SearchField;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContributionSupport;
import org.sonatype.nexus.repository.search.sql.query.syntax.ExactTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlPredicate;
import org.sonatype.nexus.repository.search.sql.query.syntax.StringTerm;
import org.sonatype.nexus.repository.search.sql.query.syntax.Term;
import org.sonatype.nexus.repository.search.sql.query.syntax.WildcardTerm;

@Named(value="keyword")
@Singleton
public class KeywordSqlSearchQueryContribution
extends SqlSearchQueryContributionSupport {
    public static final String NAME = "keyword";
    private static final String GAVEC_REGEX = "^(?<group>[^\\s:]+):(?<name>[^\\s:]+)(:(?<version>[^\\s:]+))?(:(?<extension>[^\\s:]+))?(:(?<classifier>[^\\s:]+))?$";
    private static final Pattern GAVEC_SPLITTER = Pattern.compile("^(?<group>[^\\s:]+):(?<name>[^\\s:]+)(:(?<version>[^\\s:]+))?(:(?<extension>[^\\s:]+))?(:(?<classifier>[^\\s:]+))?$");

    public Optional<Expression> createPredicate(SearchFilter filter) {
        this.log.debug("Creating predicate for {}", (Object)filter);
        if (filter == null) {
            return Optional.empty();
        }
        String value = filter.getValue();
        if (Strings2.isBlank((String)value)) {
            return Optional.empty();
        }
        Matcher gavSearchMatcher = GAVEC_SPLITTER.matcher(value.trim());
        if (gavSearchMatcher.matches()) {
            return this.createGavPredicate(gavSearchMatcher);
        }
        return super.createPredicate(filter);
    }

    private Optional<Expression> createGavPredicate(Matcher gavSearchMatcher) {
        ArrayList expressions = new ArrayList();
        KeywordSqlSearchQueryContribution.from(gavSearchMatcher, "group", SearchField.NAMESPACE).ifPresent(expressions::add);
        KeywordSqlSearchQueryContribution.from(gavSearchMatcher, "name", SearchField.NAME).ifPresent(expressions::add);
        KeywordSqlSearchQueryContribution.from(gavSearchMatcher, "version", SearchField.VERSION).ifPresent(expressions::add);
        KeywordSqlSearchQueryContribution.from(gavSearchMatcher, "extension", SearchField.FORMAT_FIELD_2).ifPresent(expressions::add);
        KeywordSqlSearchQueryContribution.from(gavSearchMatcher, "classifier", SearchField.FORMAT_FIELD_3).ifPresent(expressions::add);
        if (expressions.isEmpty()) {
            this.log.debug("Found no GAVEC expressions in {}", (Object)gavSearchMatcher);
            return Optional.empty();
        }
        this.log.debug("Created expressions for GAVEC {}", expressions);
        return Optional.of(SqlClause.create((Operand)Operand.AND, expressions));
    }

    protected StringTerm createMatchTerm(boolean exact, String value) {
        return new WildcardTerm(value);
    }

    private static Optional<Expression> from(Matcher matcher, String name, SearchField field) {
        String val = matcher.group(name);
        if (Strings2.isBlank((String)val)) {
            return Optional.empty();
        }
        return Optional.of(new SqlPredicate(Operand.EQ, field, (Term)new ExactTerm(val)));
    }
}

