/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.query;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.query.security.SqlSearchPermissionBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.query.SearchFilter;
import org.sonatype.nexus.repository.search.sql.SqlSearchQueryContribution;
import org.sonatype.nexus.repository.search.sql.query.syntax.Expression;
import org.sonatype.nexus.repository.search.sql.query.syntax.Operand;
import org.sonatype.nexus.repository.search.sql.query.syntax.SqlClause;

@Named
@Singleton
public class ExpressionBuilder
extends ComponentSupport {
    private final SqlSearchPermissionBuilder permissionBuilder;
    private Map<String, SqlSearchQueryContribution> handlers;

    @Inject
    public ExpressionBuilder(SqlSearchPermissionBuilder permissionBuilder, Map<String, SqlSearchQueryContribution> handlers) {
        this.permissionBuilder = (SqlSearchPermissionBuilder)((Object)Preconditions.checkNotNull((Object)((Object)permissionBuilder)));
        this.handlers = (Map)Preconditions.checkNotNull(handlers);
    }

    public Optional<Expression> from(SearchRequest request) {
        ArrayList expressions = new ArrayList();
        this.createExpressionFromFilters(request).ifPresent(expressions::add);
        this.permissionBuilder.build(request).ifPresent(expressions::add);
        this.log.debug("Created expressions {}", expressions);
        if (expressions.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SqlClause.create((Operand)Operand.AND, expressions));
    }

    private Optional<Expression> createExpressionFromFilters(SearchRequest request) {
        this.log.debug("Search request {}", (Object)request);
        List expressions = request.getSearchFilters().stream().filter(Objects::nonNull).filter(filter -> !"repository_name".equalsIgnoreCase(filter.getProperty())).map(this::toExpression).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (expressions.isEmpty()) {
            return Optional.empty();
        }
        Operand op = request.isConjunction() ? Operand.AND : Operand.OR;
        this.log.debug("Creating clause {} for {}", (Object)op, expressions);
        return Optional.of(SqlClause.create((Operand)op, expressions));
    }

    private Optional<Expression> toExpression(@Nullable SearchFilter filter) {
        this.log.debug("Applying handler for {}", (Object)filter);
        return Optional.ofNullable(filter).map(SearchFilter::getProperty).map(this.handlers::get).orElseGet(() -> this.handlers.get("default")).createPredicate(filter);
    }
}

