/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.index;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.search.index.SearchUpdateService;

@Named
@Singleton
public class SqlSearchUpdateService
implements SearchUpdateService {
    private final SearchStore searchTableStore;

    @Inject
    public SqlSearchUpdateService(SearchStore searchTableStore) {
        this.searchTableStore = (SearchStore)((Object)Preconditions.checkNotNull((Object)((Object)searchTableStore)));
    }

    public boolean needsReindex(Repository repository) {
        if ("group".equals(repository.getType().getValue())) {
            return false;
        }
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        Object indexOutdated = contentFacet.attributes().get("search_index_outdated");
        if (indexOutdated instanceof Boolean) {
            return (Boolean)indexOutdated;
        }
        return this.searchTableStore.repositoryNeedsReindex(repository.getName());
    }

    public void doneReindexing(Repository repository) {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        contentFacet.withoutAttribute("search_index_outdated");
    }
}

