/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.index;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.index.ComponentNotFoundException;
import com.sonatype.nexus.distributed.internal.search.sql.index.SearchRecordProducer;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchRecordData;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchStore;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.store.InternalIds;

@Named
@Singleton
public class SqlSearchIndexService
extends ComponentSupport {
    private final SearchRecordProducer searchRecordProducer;
    private final SearchStore searchStore;

    @Inject
    public SqlSearchIndexService(SearchRecordProducer searchTableDataProducer, SearchStore searchStore) {
        this.searchRecordProducer = (SearchRecordProducer)((Object)Preconditions.checkNotNull((Object)((Object)searchTableDataProducer)));
        this.searchStore = (SearchStore)((Object)Preconditions.checkNotNull((Object)((Object)searchStore)));
    }

    public void indexBatch(Collection<FluentComponent> components, Repository repository) {
        this.log.debug("Saving batch of components for repository: {}", (Object)repository.getName());
        List<SearchRecordData> searchData = components.stream().map(component -> this.searchRecordProducer.createSearchRecord((FluentComponent)component, repository)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        try {
            this.searchStore.saveBatch(searchData);
        }
        catch (Exception batchError) {
            this.log.debug("Failed batch insertion, retrying components", (Throwable)batchError);
            searchData.forEach(this::saveToStore);
        }
    }

    public void purge(Collection<EntityId> componentIds, Repository repository) {
        ContentFacet facet = (ContentFacet)repository.facet(ContentFacet.class);
        Set<Integer> internalIds = componentIds.stream().map(InternalIds::toInternalId).collect(Collectors.toSet());
        this.log.debug("Purging indexes for component ids: {} and repository: {}", componentIds, (Object)repository.getName());
        this.searchStore.deleteComponentIds(facet.contentRepositoryId(), internalIds, repository.getFormat().getValue());
    }

    public void index(Collection<EntityId> componentIds, Repository repository) {
        componentIds.forEach(componentId -> this.indexSearchData((EntityId)componentId, repository));
    }

    private void indexSearchData(EntityId componentId, Repository repository) {
        try {
            this.log.debug("Indexing component id: {}, repository: {}", (Object)componentId, (Object)repository.getName());
            this.refreshComponentData(componentId, repository);
        }
        catch (ComponentNotFoundException ex) {
            this.log.debug("Skipping refresh because: {}", (Object)ex.getMessage());
        }
    }

    private Optional<SearchRecordData> refreshComponentData(EntityId componentId, Repository repository) {
        FluentComponent componentFromDb = this.fetchComponentFromDb(componentId, repository);
        return Optional.ofNullable(this.searchRecordProducer.createSearchRecord(componentFromDb, repository).map(this::saveToStore).orElseGet(() -> {
            this.searchStore.delete(((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId(), InternalIds.toInternalId((EntityId)componentId), repository.getFormat().getValue());
            return null;
        }));
    }

    private FluentComponent fetchComponentFromDb(EntityId componentId, Repository repository) {
        return (FluentComponent)((ContentFacet)repository.facet(ContentFacet.class)).components().find(componentId).orElseThrow(() -> new ComponentNotFoundException(String.format("Component %d not found for repository %s and format %s", InternalIds.toInternalId((EntityId)componentId), repository.getName(), repository.getFormat().getValue())));
    }

    private SearchRecordData saveToStore(SearchRecordData data) {
        this.log.debug("Saving {} to component_search table", (Object)data);
        try {
            this.searchStore.save(data);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Failed to update search record for {}:{}:{} in {} cause {}", new Object[]{data.getNamespace(), data.getComponentName(), data.getVersion(), data.getRepositoryName(), e.getMessage()});
            }
            this.log.warn("Failed to update search record for {}:{}:{} in {}", new Object[]{data.getNamespace(), data.getComponentName(), data.getVersion(), data.getRepositoryName(), e});
        }
        return data;
    }
}

