/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.sonatype.nexus.distributed.internal.search.sql.index.SqlSearchIndexService;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchStore;
import java.util.Collection;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.shiro.util.CollectionUtils;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Priority(value=0x7FFFFFFF)
@Named
public class SqlSearchFacetImpl
extends FacetSupport
implements SearchFacet {
    private final SearchStore store;
    private final SqlSearchIndexService sqlSearchIndexService;
    private final int batchSize;

    @Inject
    public SqlSearchFacetImpl(SearchStore store, SqlSearchIndexService sqlSearchIndexService, @Named(value="${nexus.rebuild.search.batchSize:-500}") @Named(value="${nexus.rebuild.search.batchSize:-500}") int batchSize) {
        this.store = (SearchStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.sqlSearchIndexService = (SqlSearchIndexService)((Object)Preconditions.checkNotNull((Object)((Object)sqlSearchIndexService)));
        Preconditions.checkState((batchSize >= 1 ? 1 : 0) != 0, (Object)"batchSize should be greater than 1");
        this.batchSize = batchSize;
    }

    @Guarded(by={"STARTED"})
    public void rebuildIndex() {
        Repository repository = this.getRepository();
        String repositoryFormat = repository.getFormat().getValue();
        String repositoryName = repository.getName();
        this.log.info("Starting regenerate the search data for the {} repository: {}", (Object)repositoryFormat, (Object)repositoryName);
        this.process(repository);
        this.log.info("Finish regenerating the search data for the {} repository: {}", (Object)repositoryFormat, (Object)repositoryName);
    }

    private void process(Repository repository) {
        String repositoryFormat = repository.getFormat().getValue();
        Integer repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        this.log.info("Processing the {} repository: {}", (Object)repositoryFormat, (Object)repository.getName());
        this.store.deleteAllForRepository(repositoryId, repositoryFormat);
        this.populateComponents(repository);
    }

    private void populateComponents(Repository repository) {
        FluentComponents fluentComponents = ((ContentFacet)this.facet(ContentFacet.class)).components();
        long processed = 0L;
        int totalComponents = fluentComponents.count();
        Throwable throwable = null;
        Object var7_7 = null;
        try (ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);){
            Stopwatch sw = Stopwatch.createStarted();
            Continuation components = fluentComponents.browse(this.batchSize, null);
            while (!CollectionUtils.isEmpty((Collection)components)) {
                CancelableHelper.checkCancellation();
                this.sqlSearchIndexService.indexBatch((Collection<FluentComponent>)components, repository);
                progressLogger.info("Indexed {} / {} {} components in {}", new Object[]{processed += (long)components.size(), totalComponents, repository.getName(), sw});
                components = fluentComponents.browse(this.batchSize, components.nextContinuationToken());
            }
            progressLogger.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Guarded(by={"STARTED"})
    public void index(Collection<EntityId> componentIds) {
        this.log.debug("Indexing... {}", componentIds);
        this.sqlSearchIndexService.index(componentIds, this.getRepository());
    }

    @Guarded(by={"STARTED"})
    public void purge(Collection<EntityId> componentIds) {
        this.log.debug("Purging... {}", componentIds);
        this.sqlSearchIndexService.purge(componentIds, this.getRepository());
    }
}

