/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.index;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.content.event.component.ComponentCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentEvent;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryDeletedEvent;
import org.sonatype.nexus.repository.content.search.SearchEventHandler;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
@FeatureFlag(name="nexus.datastore.table.search.enabled")
public class SqlSearchEventHandler
extends SearchEventHandler
implements EventAware {
    private final SearchStore searchTableStore;

    @Inject
    public SqlSearchEventHandler(SearchStore searchTableStore, RepositoryManager repositoryManager, PeriodicJobService periodicJobService, @Named(value="${nexus.search.event.handler.flushOnCount:-100}") @Named(value="${nexus.search.event.handler.flushOnCount:-100}") int flushOnCount, @Named(value="${nexus.search.event.handler.flushOnSeconds:-2}") @Named(value="${nexus.search.event.handler.flushOnSeconds:-2}") int flushOnSeconds, @Named(value="${nexus.search.event.handler.noPurgeDelay:-true}") @Named(value="${nexus.search.event.handler.noPurgeDelay:-true}") boolean noPurgeDelay, @Named(value="${nexus.search.event.handler.flushPoolSize:-128}") @Named(value="${nexus.search.event.handler.flushPoolSize:-128}") int poolSize) {
        super(repositoryManager, periodicJobService, flushOnCount, flushOnSeconds, noPurgeDelay, poolSize);
        this.searchTableStore = (SearchStore)((Object)Preconditions.checkNotNull((Object)((Object)searchTableStore)));
    }

    protected String getThreadPoolId() {
        return "sqlSearchEventHandler";
    }

    protected void requestIndex(ComponentEvent event) {
        if (event instanceof ComponentCreatedEvent) {
            this.log.debug("Skipping component created event for {}:{}:{}", new Object[]{event.getComponent().namespace(), event.getComponent().name(), event.getComponent().version()});
            return;
        }
        super.requestIndex(event);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ContentRepositoryDeletedEvent event) {
        this.threadPoolExecutor.execute(() -> {
            boolean bl = this.deleteRepositoryComponents(event);
        });
    }

    private boolean deleteRepositoryComponents(ContentRepositoryDeletedEvent event) {
        int repositoryId = InternalIds.contentRepositoryId((ContentStoreEvent)event);
        String format = event.getFormat();
        this.log.debug("Deleting repository id: {}, format: {} from component_search", (Object)repositoryId, (Object)format);
        return this.searchTableStore.deleteAllForRepository(repositoryId, format);
    }
}

