/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.search.sql.index;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.search.sql.store.SearchRecordData;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.search.sql.SearchCustomFieldContributor;
import org.sonatype.nexus.repository.content.search.sql.SearchRecordExtension;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.content.utils.PreReleaseEvaluator;
import org.sonatype.nexus.repository.content.utils.SearchComponentPathFilter;
import org.sonatype.nexus.repository.search.normalize.VersionNormalizerService;
import org.sonatype.nexus.repository.search.sql.SearchRecord;

@Named
@Singleton
public class SearchRecordProducer
extends ComponentSupport {
    private static final String PATH_SPLIT_REGEX = "[/]+";
    private final Map<String, SearchCustomFieldContributor> searchCustomFieldContributors;
    private final VersionNormalizerService versionNormalizerService;
    private final Map<String, PreReleaseEvaluator> formatToReleaseEvaluators;
    private final Map<String, SearchComponentPathFilter> formatToValidatePath;
    private final Set<SearchRecordExtension> searchTableDataExtensions;

    @Inject
    public SearchRecordProducer(Map<String, SearchCustomFieldContributor> searchCustomFieldContributors, VersionNormalizerService versionNormalizerService, Map<String, PreReleaseEvaluator> formatToReleaseEvaluators, Map<String, SearchComponentPathFilter> formatToValidatePath, Set<SearchRecordExtension> searchTableDataExtensions) {
        this.searchCustomFieldContributors = (Map)Preconditions.checkNotNull(searchCustomFieldContributors);
        this.versionNormalizerService = (VersionNormalizerService)Preconditions.checkNotNull((Object)versionNormalizerService);
        this.formatToReleaseEvaluators = (Map)Preconditions.checkNotNull(formatToReleaseEvaluators);
        this.formatToValidatePath = (Map)Preconditions.checkNotNull(formatToValidatePath);
        this.searchTableDataExtensions = (Set)Preconditions.checkNotNull(searchTableDataExtensions);
    }

    public Optional<SearchRecordData> createSearchRecord(FluentComponent component, Repository repository) {
        Integer repositoryId = ((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId();
        String repositoryName = repository.getName();
        String repositoryFormat = repository.getFormat().getValue();
        SearchRecordData data = new SearchRecordData();
        data.setRepositoryId(repositoryId);
        data.setComponentId(InternalIds.internalComponentId((Component)component));
        data.setFormat(repositoryFormat);
        data.setNamespace(component.namespace());
        data.setComponentName(component.name());
        data.addAliasComponentName(component.name());
        data.setComponentKind(component.kind());
        data.setVersion(component.version());
        data.setNormalisedVersion(this.versionNormalizerService.getNormalizedVersionByFormat(component.version(), repository.getFormat()));
        data.setRepositoryName(repositoryName);
        data.addKeywords(Arrays.asList(component.namespace(), component.name(), component.version()));
        data.setEntityVersion(component.entityVersion());
        data.setAttributes(component.attributes());
        Collection assets = component.assets();
        if (assets.isEmpty()) {
            this.log.debug("Component {}:{}:{} has no assets", new Object[]{component.namespace(), component.name(), component.version()});
            return Optional.empty();
        }
        assets.stream().map(Asset::blob).filter(Optional::isPresent).map(Optional::get).map(AssetBlob::blobCreated).max(OffsetDateTime::compareTo).ifPresent(data::setLastModified);
        assets.forEach(asset -> this.addAssetData(data, (Component)component, (Asset)asset, repository));
        this.addSearchExtensions(data, component);
        return Optional.of(data);
    }

    private void addAssetData(SearchRecord searchTableData, Component component, Asset asset, Repository repository) {
        Optional blob = asset.blob();
        String repositoryFormat = repository.getFormat().getValue();
        if (blob.isPresent()) {
            SearchRecordProducer.addBlobInfo((AssetBlob)blob.get(), searchTableData);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Unable to determine blob for asset {}", (Object)asset.path());
        }
        SearchCustomFieldContributor contributor = this.searchCustomFieldContributors.get(repositoryFormat);
        if (contributor != null) {
            if (contributor.isEnableSearchByPath(asset.path())) {
                this.splitAssetPathToKeywords(searchTableData, asset, repositoryFormat);
            }
            contributor.populateSearchCustomFields(searchTableData, asset);
        } else {
            this.splitAssetPathToKeywords(searchTableData, asset, repositoryFormat);
        }
        PreReleaseEvaluator evaluator = this.formatToReleaseEvaluators.get(repositoryFormat);
        boolean preRelease = evaluator != null && evaluator.isPreRelease(component, Collections.singletonList(asset));
        searchTableData.setPrerelease(preRelease);
    }

    private static void addBlobInfo(AssetBlob blob, SearchRecord data) {
        data.addKeyword(blob.contentType());
        data.addMd5((String)blob.checksums().get(HashAlgorithm.MD5.name()));
        data.addSha1((String)blob.checksums().get(HashAlgorithm.SHA1.name()));
        data.addSha256((String)blob.checksums().get(HashAlgorithm.SHA256.name()));
        data.addSha512((String)blob.checksums().get(HashAlgorithm.SHA512.name()));
        blob.createdBy().ifPresent(arg_0 -> ((SearchRecord)data).addUploader(arg_0));
        blob.createdByIp().ifPresent(arg_0 -> ((SearchRecord)data).addUploaderIp(arg_0));
    }

    private void splitAssetPathToKeywords(SearchRecord searchTableData, Asset asset, String repositoryFormat) {
        boolean shouldFilterPath;
        String path = asset.path();
        SearchComponentPathFilter filter = this.formatToValidatePath.get(repositoryFormat);
        boolean bl = shouldFilterPath = filter != null && filter.shouldFilterPathExtension(path);
        if (!shouldFilterPath) {
            searchTableData.addPath(path);
            searchTableData.addKeywords(Arrays.asList(path.split(PATH_SPLIT_REGEX)));
            searchTableData.addKeywords(Collections.singletonList(path));
        }
    }

    private void addSearchExtensions(SearchRecord searchTableData, FluentComponent component) {
        for (SearchRecordExtension extension : this.searchTableDataExtensions) {
            extension.contribute(searchTableData, component);
        }
    }
}

