/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.rest;

import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.node.datastore.NodeHeartbeat;
import org.sonatype.nexus.rest.Resource;

@Produces(value={"application/json"})
@Path(value="/beta/system/nodes")
@Named
@Singleton
public class SystemNodesApiResource
extends ComponentSupport
implements Resource {
    public static final String PATH = "/beta/system/nodes";
    private static final String NODES = "nodes";
    private static final String NODE_ID = "nodeId";
    private final NodeHeartbeatStore nodeHeartbeatStore;

    @Inject
    public SystemNodesApiResource(NodeHeartbeatStore nodeHeartbeatStore) {
        this.nodeHeartbeatStore = nodeHeartbeatStore;
    }

    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Map<String, List<Map<String, Object>>> getNodesList() {
        List ids = this.nodeHeartbeatStore.getActiveNodes().stream().map(NodeHeartbeat::nodeInfo).map(info -> Collections.singletonMap(NODE_ID, info.get(NODE_ID))).collect(Collectors.toList());
        return Collections.singletonMap(NODES, ids);
    }
}

