/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.ClusteredUpgradeServiceImpl;
import com.sonatype.nexus.distributed.internal.UpgradeRequestException;
import com.sonatype.nexus.distributed.internal.rest.ApiClusterDatabaseMigrationResultDTO;
import com.sonatype.nexus.distributed.internal.rest.DistributedDatabaseUpgradeResourceDoc;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.security.UserIdHelper;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="v1/clustered/upgrade-database-schema")
@Named
@Singleton
public class DistributedMigrationDatabaseV1ApiResource
extends ComponentSupport
implements Resource,
DistributedDatabaseUpgradeResourceDoc {
    private static final String MSG_NO_UPGRADES = "No migrations available.";
    private static final String MSG_PREVIOUS_ERROR = "A previous migration failed and cannot be recovered. Please contact support for assistance.";
    private final ClusteredUpgradeServiceImpl upgradeService;

    @Inject
    public DistributedMigrationDatabaseV1ApiResource(ClusteredUpgradeServiceImpl upgradeService) {
        this.upgradeService = (ClusteredUpgradeServiceImpl)((Object)Preconditions.checkNotNull((Object)((Object)upgradeService)));
    }

    @Override
    @RequiresPermissions(value={"nexus:*"})
    @POST
    public Response migrate() {
        if (!this.upgradeService.requiresMigration()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)MSG_NO_UPGRADES).build();
        }
        try {
            this.upgradeService.initiate(UserIdHelper.get());
            return Response.noContent().build();
        }
        catch (UpgradeRequestException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Override
    @RequiresPermissions(value={"nexus:*"})
    @GET
    public ApiClusterDatabaseMigrationResultDTO getProgress() {
        return this.upgradeService.getClusterDatabaseUpgradeResult().map(ApiClusterDatabaseMigrationResultDTO::from).orElseGet(this::get);
    }

    @Override
    @RequiresPermissions(value={"nexus:*"})
    @DELETE
    public void clearResult(@QueryParam(value="force") Boolean force) {
        boolean forceClear = Boolean.TRUE.equals(force);
        if (!this.upgradeService.clearResult(forceClear)) {
            throw new BadRequestException(MSG_PREVIOUS_ERROR);
        }
    }

    private ApiClusterDatabaseMigrationResultDTO get() {
        if (this.upgradeService.isInProgress()) {
            return ApiClusterDatabaseMigrationResultDTO.started();
        }
        return ApiClusterDatabaseMigrationResultDTO.noResult(this.upgradeService.requiresMigration());
    }
}

