/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.ClusterDatabaseUpgradeResult;
import com.sonatype.nexus.distributed.internal.rest.ApiMigrationState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class ApiClusterDatabaseMigrationResultDTO {
    private final String message;
    private final ApiMigrationState state;

    private ApiClusterDatabaseMigrationResultDTO(ApiMigrationState state, String message) {
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.state = (ApiMigrationState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
    }

    @ApiModelProperty(value="Provides a message indicating the current state of the migration")
    public String getMessage() {
        return this.message;
    }

    @ApiModelProperty(value="Provides the current migration state.")
    public ApiMigrationState getState() {
        return this.state;
    }

    public static ApiClusterDatabaseMigrationResultDTO noResult(boolean upgradeRequired) {
        if (upgradeRequired) {
            return new ApiClusterDatabaseMigrationResultDTO(ApiMigrationState.MIGRATION_REQUIRED, "The system requires migration");
        }
        return new ApiClusterDatabaseMigrationResultDTO(ApiMigrationState.MIGRATION_NOT_REQUIRED, "The system is up to date");
    }

    public static ApiClusterDatabaseMigrationResultDTO started() {
        return new ApiClusterDatabaseMigrationResultDTO(ApiMigrationState.MIGRATION_IN_PROGRESS, "Migration in progress");
    }

    public static ApiClusterDatabaseMigrationResultDTO from(ClusterDatabaseUpgradeResult internal) {
        if (internal.isSuccessful()) {
            return new ApiClusterDatabaseMigrationResultDTO(ApiMigrationState.MIGRATION_SUCCEED, internal.getMessage());
        }
        if (internal.isError() && Boolean.TRUE.equals(internal.isRecoverable())) {
            return new ApiClusterDatabaseMigrationResultDTO(ApiMigrationState.MIGRATION_FAILED_RETRYABLE, internal.getMessage());
        }
        return new ApiClusterDatabaseMigrationResultDTO(ApiMigrationState.MIGRATION_FAILED, internal.getMessage());
    }
}

