/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.freeze;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.freeze.FreezeRequestData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.api.DataAccessException;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;

@Named
@Singleton
public class FreezeRequestJdbcStore
extends StateGuardLifecycleSupport {
    private static final String TABLE_NOT_FOUND = "42S02";
    private static final String DELETE_BY_TOKEN = "DELETE FROM freeze_requests WHERE token = ?;";
    private static final String DELETE_BY_USER = "DELETE FROM freeze_requests WHERE frozen_by = ?;";
    private static final String DELETE_ALL = "DELETE FROM freeze_requests";
    private static final String INSERT = "INSERT INTO freeze_requests (token, reason, frozen_by, frozen_by_ip) VALUES (?, ?, ?, ?)";
    private final DataSessionSupplier sessionSupplier;

    @Inject
    public FreezeRequestJdbcStore(DataSessionSupplier sessionSupplier) {
        this.sessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)sessionSupplier);
    }

    public int clear() {
        return this.update(DELETE_ALL, __ -> {
            List list = Collections.emptyList();
        });
    }

    /*
     * Loose catch block
     */
    public boolean isFrozen() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection conn = this.sessionSupplier.openConnection("nexus");){
                boolean bl;
                PreparedStatement statement;
                Throwable throwable2;
                block22: {
                    throwable2 = null;
                    Object var5_9 = null;
                    statement = conn.prepareStatement("SELECT count(*) FROM freeze_requests");
                    ResultSet result = statement.executeQuery();
                    bl = result.next() && result.getInt(1) > 0;
                    if (statement == null) break block22;
                    statement.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (statement != null) {
                                statement.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            if (!TABLE_NOT_FOUND.equals(e.getSQLState())) {
                this.log.warn("An unexpected error occurred while checking read-only state", (Throwable)e);
            }
            return false;
        }
    }

    public void freeze(FreezeRequestData request) {
        this.insert(request);
    }

    public boolean releaseByToken(String token) {
        return this.update(DELETE_BY_TOKEN, stmt -> stmt.setString(1, token)) > 0;
    }

    public void releaseByUser(String userId) {
        this.update(DELETE_BY_USER, stmt -> stmt.setString(1, userId));
    }

    private void insert(FreezeRequestData freezeRequest) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection conn = this.sessionSupplier.openConnection("nexus");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (PreparedStatement stmt = conn.prepareStatement(INSERT, 1);){
                    stmt.setString(1, freezeRequest.token().orElse(null));
                    stmt.setString(2, freezeRequest.reason());
                    stmt.setString(3, freezeRequest.frozenBy().orElse(null));
                    stmt.setString(4, freezeRequest.frozenByIp().orElse(null));
                    stmt.executeUpdate();
                    ResultSet generatedKeys = stmt.getGeneratedKeys();
                    generatedKeys.next();
                    freezeRequest.setId(generatedKeys.getInt(1));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            FreezeRequestJdbcStore.handle(e);
        }
    }

    /*
     * Loose catch block
     */
    private int update(String sql, ParameterSetter setter) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = this.sessionSupplier.openConnection("nexus");){
                int n;
                PreparedStatement stmt;
                Throwable throwable2;
                block21: {
                    throwable2 = null;
                    Object var7_11 = null;
                    stmt = conn.prepareStatement(sql);
                    setter.accept(stmt);
                    n = stmt.executeUpdate();
                    if (stmt == null) break block21;
                    stmt.close();
                }
                return n;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            FreezeRequestJdbcStore.handle(e);
            return -1;
        }
    }

    private static void handle(SQLException e) {
        switch (e.getSQLState()) {
            case "23505": {
                throw new DuplicateKeyException((Throwable)e);
            }
        }
        throw new DataAccessException("An unexpected error occurred", (Throwable)e);
    }

    @FunctionalInterface
    private static interface ParameterSetter {
        public void accept(PreparedStatement var1) throws SQLException;
    }
}

