/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.freeze;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.freeze.FreezeRequestJdbcStore;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.Freezable;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
@Singleton
public class EarlyFreezeService
extends StateGuardLifecycleSupport {
    private final List<Freezable> freezables;
    private final FreezeRequestJdbcStore store;

    @Inject
    public EarlyFreezeService(FreezeRequestJdbcStore store, List<Freezable> freezables) {
        this.store = (FreezeRequestJdbcStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.freezables = (List)Preconditions.checkNotNull(freezables);
    }

    protected void doStart() {
        if (this.store.isFrozen()) {
            this.log.info("Database set to read-only mode.");
            this.freezables.forEach(this::tryFreeze);
        }
    }

    private void tryFreeze(Freezable freezable) {
        try {
            freezable.freeze();
        }
        catch (Exception e) {
            this.log.warn("Problem freezing {}", (Object)freezable, (Object)e);
        }
    }
}

