/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.freeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.internal.freeze.FreezeRequestData;
import com.sonatype.nexus.distributed.internal.freeze.FreezeRequestJdbcStore;
import com.sonatype.nexus.distributed.internal.freeze.FreezeRequestStore;
import com.sonatype.nexus.distributed.internal.freeze.FreezeRequestsChangedEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.sonatype.nexus.common.app.Freezable;
import org.sonatype.nexus.common.app.FreezeRequest;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.NotReadableException;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.security.ClientInfoProvider;

@Priority(value=0x7FFFFFFF)
@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class DistributedFreezeService
extends StateGuardLifecycleSupport
implements FreezeService,
EventAware {
    @VisibleForTesting
    static final String ANONYMOUS = "anonymous";
    private final FreezeRequestStore store;
    private final FreezeRequestJdbcStore jdbcStore;
    private final ClientInfoProvider clientInfoProvider;
    private final EventManager eventManager;
    private final NodeAccess nodeAccess;
    private final Provider<List<Freezable>> freezableProvider;
    private List<Freezable> freezables;

    @Inject
    public DistributedFreezeService(ClientInfoProvider clientInfoProvider, EventManager eventManager, FreezeRequestStore store, FreezeRequestJdbcStore jdbcStore, NodeAccess nodeAccess, Provider<List<Freezable>> freezableProvider) {
        this.store = (FreezeRequestStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.jdbcStore = (FreezeRequestJdbcStore)((Object)Preconditions.checkNotNull((Object)((Object)jdbcStore)));
        this.clientInfoProvider = (ClientInfoProvider)Preconditions.checkNotNull((Object)clientInfoProvider);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.freezableProvider = (Provider)Preconditions.checkNotNull(freezableProvider);
    }

    protected void doStart() {
        this.updateState();
    }

    public void requestFreeze(String reason) {
        this.saveUserFreezeRequest(this.newRequest(null, reason));
        this.updateState();
    }

    public void cancelFreeze() {
        this.jdbcStore.releaseByUser(this.currentUserId());
        this.updateState();
    }

    public void taskRequestFreeze(String token, String reason) {
        this.saveUserFreezeRequest(this.newRequest((String)Preconditions.checkNotNull((Object)token), reason));
        this.updateState();
    }

    public void taskCancelFreeze(String token) {
        this.jdbcStore.releaseByToken((String)Preconditions.checkNotNull((Object)token));
        this.updateState();
    }

    public List<FreezeRequest> cancelAllFreezeRequests() {
        this.log.debug("Cancel all freeze requests");
        List<FreezeRequestData> canceledRequests = this.store.getAll();
        int cleared = this.jdbcStore.clear();
        this.log.debug("Cleared {} found {}", (Object)cleared, canceledRequests);
        this.updateState();
        return ImmutableList.copyOf(canceledRequests);
    }

    public boolean isFrozen() {
        return this.jdbcStore.isFrozen();
    }

    public List<FreezeRequest> currentFreezeRequests() {
        return ImmutableList.copyOf(this.store.getAll());
    }

    public void checkReadable(String errorMessage) {
        try {
            this.store.getAll();
        }
        catch (Exception e) {
            throw new NotReadableException(String.valueOf(errorMessage) + ". Database not readable on node: " + this.nodeAccess.getId(), (Throwable)e);
        }
    }

    public void checkWritable(String errorMessage) {
        if (this.isFrozen()) {
            throw new FrozenException(errorMessage);
        }
    }

    @Subscribe
    public void on(FreezeRequestsChangedEvent event) {
        if (EventHelper.isReplicating()) {
            this.updateState();
        }
    }

    private void updateState() {
        if (this.jdbcStore.isFrozen()) {
            this.freeze();
        } else {
            this.unfreeze();
        }
    }

    private FreezeRequestData newRequest(@Nullable String token, String reason) {
        Optional<ClientInfo> clientInfo = Optional.ofNullable(this.clientInfoProvider.getCurrentThreadClientInfo());
        return new FreezeRequestData(null, token, reason, DateTime.now((DateTimeZone)DateTimeZone.UTC), this.currentUserId(), clientInfo.map(ClientInfo::getRemoteIP).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeze() {
        List<Freezable> list = this.freezables();
        synchronized (list) {
            if (this.jdbcStore.isFrozen()) {
                this.notifyChanged();
                this.freezables().forEach(this::tryFreeze);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unfreeze() {
        List<Freezable> list = this.freezables();
        synchronized (list) {
            if (!this.jdbcStore.isFrozen()) {
                Lists.reverse(this.freezables()).forEach(this::tryUnfreeze);
                this.notifyChanged();
            }
        }
    }

    private void tryFreeze(Freezable freezable) {
        try {
            freezable.freeze();
        }
        catch (Exception e) {
            this.log.warn("Problem freezing {}", (Object)freezable, (Object)e);
        }
    }

    private void tryUnfreeze(Freezable freezable) {
        try {
            freezable.unfreeze();
        }
        catch (Exception e) {
            this.log.warn("Problem unfreezing {}", (Object)freezable, (Object)e);
        }
    }

    private void saveUserFreezeRequest(FreezeRequestData request) {
        try {
            this.jdbcStore.freeze(request);
        }
        catch (Exception e) {
            this.log.warn("Unable to persist freeze request, other nodes may be writable", (Throwable)e);
        }
    }

    @Nullable
    private String currentUserId() {
        ClientInfo clientInfo = this.clientInfoProvider.getCurrentThreadClientInfo();
        if (clientInfo == null) {
            return null;
        }
        return Optional.ofNullable(clientInfo.getUserid()).orElse(ANONYMOUS);
    }

    private void notifyChanged() {
        if (EventHelper.isReplicating()) {
            return;
        }
        try {
            this.eventManager.post((Object)new FreezeRequestsChangedEvent());
        }
        catch (Exception e) {
            this.log.debug("Failed to broadcast freeze request", (Throwable)e);
        }
    }

    private synchronized List<Freezable> freezables() {
        if (this.freezables == null) {
            this.freezables = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull((Object)((List)this.freezableProvider.get()))));
        }
        return this.freezables;
    }
}

