/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event.subscribers;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.distributed.event.service.api.common.DataStoreConfigurationEvent;

@Named
@Singleton
public class DataStoreEventSubscriber
extends ComponentSupport
implements EventAware {
    private final DataStoreManager dataStoreManager;

    @Inject
    public DataStoreEventSubscriber(DataStoreManager dataStoreManager) {
        this.dataStoreManager = (DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager);
    }

    @Subscribe
    public void on(DataStoreConfigurationEvent event) throws Exception {
        if (EventHelper.isReplicating()) {
            DataStoreConfiguration configuration = new DataStoreConfiguration();
            configuration.setName(event.getConfigurationName());
            configuration.setType(event.getType());
            configuration.setSource(event.getSource());
            configuration.setAttributes(event.getAttributes());
            this.dataStoreManager.update(configuration);
        }
    }
}

