/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.event.DistributedEventProducer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rest.Resource;

@FeatureFlag(name="nexus.internal.ha.tests")
@Named
@Singleton
@Path(value="internal/test/distributed-events-service")
@Consumes(value={"application/json"})
public class PauseDistributedEventServiceResource
extends ComponentSupport
implements Resource {
    private final DistributedEventProducer producer;

    @Inject
    public PauseDistributedEventServiceResource(DistributedEventProducer producer) {
        this.producer = (DistributedEventProducer)((Object)Preconditions.checkNotNull((Object)((Object)producer)));
        this.log.info("Pause distributed event service started");
    }

    @RequiresPermissions(value={"nexus:*"})
    @RequiresAuthentication
    @Path(value="flush")
    @POST
    public void flush() {
        this.log.warn("Flushing event producer");
        this.producer.flush();
    }

    @RequiresPermissions(value={"nexus:*"})
    @RequiresAuthentication
    @Path(value="pause")
    @POST
    public void pause() {
        this.log.warn("Pausing event producer");
        this.producer.pause();
    }

    @RequiresPermissions(value={"nexus:*"})
    @RequiresAuthentication
    @Path(value="resume")
    @POST
    public void resume() {
        this.log.warn("Resuming event producer");
        this.producer.resume();
    }
}

