/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.event.DistributedEventData;
import com.sonatype.nexus.distributed.event.DistributedEventStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventWithSource;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
public class DistributedEventPublisher
extends ComponentSupport
implements EventAware {
    private final DistributedEventStore store;
    private final NodeAccess nodeAccess;
    private ObjectMapper mapper;

    @Inject
    public DistributedEventPublisher(DistributedEventStore store, ObjectMapper mapper, NodeAccess nodeAccess) {
        this.store = (DistributedEventStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.mapper = ((ObjectMapper)Preconditions.checkNotNull((Object)mapper)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(EventWithSource event) {
        if (!event.isLocal()) {
            return;
        }
        try {
            DistributedEventData data = this.createDistributedEventData(this.nodeAccess.getId(), event);
            this.log.debug("Source node: {}, publishing {}", (Object)this.nodeAccess.getId(), (Object)data.getEventType());
            this.store.publishEvent(data);
        }
        catch (JsonProcessingException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error("An error occurred publishing distributed event.", (Throwable)e);
            }
            this.log.error("An error occurred publishing distributed event. Cause: {}", (Object)e.getMessage());
        }
    }

    private DistributedEventData createDistributedEventData(String nodeId, EventWithSource event) throws JsonProcessingException {
        DistributedEventData data = new DistributedEventData();
        data.setEventType(event.getClass().getName());
        data.setSourceNode(this.nodeAccess.getId());
        data.setEventData(this.mapper.writerFor(event.getClass()).writeValueAsString((Object)event));
        return data;
    }
}

