/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.event.DistributedEventData;
import com.sonatype.nexus.distributed.event.DistributedEventStore;
import com.sonatype.nexus.distributed.internal.DistributedEventPollInterval;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.event.EventWithSource;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class DistributedEventProducer
extends LifecycleSupport
implements EventAware {
    private static final int EVENT_FETCH_LIMIT = Integer.MAX_VALUE;
    private final int eventFetchInterval;
    private final DistributedEventStore store;
    private final EventManager eventManager;
    private final PeriodicJobService periodicJobService;
    private final NodeAccess nodeAccess;
    private final OffsetDateTime nodeStartTime = OffsetDateTime.now(ZoneOffset.UTC);
    private PeriodicJobService.PeriodicJob publisherTask;
    private String continuationToken;
    private boolean paused = false;
    private ClassLoader classLoader;
    private ObjectMapper mapper;

    @Inject
    public DistributedEventProducer(@Named(value="nexus-uber") @Named(value="nexus-uber") ClassLoader classLoader, ObjectMapper mapper, DistributedEventStore store, EventManager eventManager, PeriodicJobService periodicJobService, DistributedEventPollInterval pollInterval, @Named NodeAccess nodeAccess) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.mapper = ((ObjectMapper)Preconditions.checkNotNull((Object)mapper)).registerModule((Module)new Jdk8Module());
        this.store = (DistributedEventStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.eventFetchInterval = (int)((DistributedEventPollInterval)Preconditions.checkNotNull((Object)pollInterval)).get().getSeconds();
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting DES events polling");
        this.periodicJobService.startUsing();
        this.publisherTask = this.periodicJobService.schedule(this::readDESEvents, this.eventFetchInterval);
    }

    protected void doStop() throws Exception {
        this.publisherTask.cancel();
        this.periodicJobService.stopUsing();
    }

    @VisibleForTesting
    void pause() {
        this.paused = true;
    }

    @VisibleForTesting
    void resume() {
        this.paused = false;
    }

    void flush() {
        boolean isPaused = this.paused;
        this.paused = false;
        this.readDESEvents();
        this.paused = isPaused;
    }

    private synchronized void readDESEvents() {
        if (this.paused) {
            this.log.info("Paused, skipping event replication.");
            return;
        }
        Continuation<DistributedEventData> continuationEvents = this.store.readRemoteEvents(this.nodeAccess.getId(), Integer.MAX_VALUE, this.continuationToken, this.nodeStartTime);
        if (CollectionUtils.isNotEmpty(continuationEvents)) {
            this.continuationToken = continuationEvents.nextContinuationToken();
            EventHelper.asReplicating(() -> continuationEvents.stream().map(this::createEvent).filter(Objects::nonNull).forEach(event -> this.eventManager.post(event)));
        }
    }

    private EventWithSource createEvent(DistributedEventData data) {
        Class<?> clazz;
        block5: {
            clazz = this.classLoader.loadClass(data.getEventType());
            if (EventWithSource.class.isAssignableFrom(clazz)) break block5;
            this.log.error("Distributed event bus contains unexpected event type {}", (Object)data.getEventType());
            return null;
        }
        try {
            EventWithSource event = (EventWithSource)this.mapper.readerFor(clazz).readValue(data.getEventData());
            event.setRemoteNodeId(data.getSourceNode());
            return event;
        }
        catch (JsonProcessingException | ClassNotFoundException e) {
            if (this.log.isDebugEnabled()) {
                this.log.error("Failed to propagate event from node {} of type {}.", new Object[]{data.getSourceNode(), data.getEventType(), e});
            } else {
                this.log.error("Failed to propagate event from node {} of type {}. Cause: {}", new Object[]{data.getSourceNode(), data.getEventType(), e.getMessage()});
            }
            return null;
        }
    }
}

