/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal.cooperation;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.cooperation.DistributedCooperation2;
import com.sonatype.nexus.distributed.internal.cooperation.DistributedCooperationRegistry;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.Priority;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.cooperation2.datastore.DefaultCooperation2Factory;

@Priority(value=0x7FFFFFFF)
@Named(value="distributed")
@Singleton
public class DistributedCooperation2Factory
extends DefaultCooperation2Factory {
    private final Duration clusteredCooperationLag;
    private final boolean clusteredCooperationEnabled;
    private final Duration distributedTimeout;
    private final int retries;
    private final DistributedCooperationRegistry distributedCooperationRegistry;

    @Inject
    public DistributedCooperation2Factory(DistributedCooperationRegistry distributedCooperationRegistry, @Named(value="${nexus.clustered.cooperation.enabled:-true}") @Named(value="${nexus.clustered.cooperation.enabled:-true}") boolean clusteredCooperationEnabled, @Named(value="${nexus.clustered.cooperation.retries:-5}") @Named(value="${nexus.clustered.cooperation.retries:-5}") int retries, @Named(value="${nexus.clustered.cooperation.lag:-10s}") @Named(value="${nexus.clustered.cooperation.lag:-10s}") Duration clusteredCooperationLag, @Named(value="${nexus.clustered.cooperation.timeout:-5m}") @Named(value="${nexus.clustered.cooperation.timeout:-5m}") Duration distributedTimeout) {
        this.clusteredCooperationLag = (Duration)Preconditions.checkNotNull((Object)clusteredCooperationLag);
        this.distributedTimeout = (Duration)Preconditions.checkNotNull((Object)distributedTimeout);
        this.distributedCooperationRegistry = (DistributedCooperationRegistry)Preconditions.checkNotNull((Object)distributedCooperationRegistry);
        this.clusteredCooperationEnabled = clusteredCooperationEnabled;
        this.retries = retries;
    }

    public Cooperation2Factory.Builder configure() {
        return new DistributedCooperation2Builder();
    }

    protected class DistributedCooperation2Builder
    extends DefaultCooperation2Factory.DefaultCooperation2Builder {
        protected DistributedCooperation2Builder() {
            super((DefaultCooperation2Factory)DistributedCooperation2Factory.this);
        }

        public Cooperation2 build(String id) {
            if (DistributedCooperation2Factory.this.clusteredCooperationEnabled && this.enabled) {
                DistributedCooperation2Factory.this.log.debug("Remote cooperation used for: {}", (Object)id);
                return new DistributedCooperation2(id, this.copy(), DistributedCooperation2Factory.this.retries, DistributedCooperation2Factory.this.distributedTimeout, DistributedCooperation2Factory.this.clusteredCooperationLag, DistributedCooperation2Factory.this.distributedCooperationRegistry);
            }
            return super.build(id);
        }

        public Cooperation2 build(Class<?> id, String ... keys) {
            if (DistributedCooperation2Factory.this.clusteredCooperationEnabled && this.enabled) {
                DistributedCooperation2Factory.this.log.debug("Remote cooperation used for: {}", id);
                return new DistributedCooperation2(DistributedCooperation2Factory.stripGuice((Class)id, (String[])keys), this.copy(), DistributedCooperation2Factory.this.retries, DistributedCooperation2Factory.this.distributedTimeout, DistributedCooperation2Factory.this.clusteredCooperationLag, DistributedCooperation2Factory.this.distributedCooperationRegistry);
            }
            return super.build(id, keys);
        }
    }
}

