/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.event.DistributedUpgradeEvent;
import com.sonatype.nexus.distributed.internal.UpgradeResultChangedEvent;
import com.sonatype.nexus.distributed.internal.rest.ApiClusterDatabaseMigrationResultDTO;
import com.sonatype.nexus.distributed.internal.rest.DistributedMigrationDatabaseV1ApiResource;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.node.datastore.NodeHeartbeat;
import org.sonatype.nexus.node.datastore.NodeHeartbeatManager;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.security.SecurityHelper;

@Singleton
@Named
public class UpgradeStateContributor
extends ComponentSupport
implements StateContributor,
EventAware,
EventAware.Asynchronous {
    private static final String NEEDS_UPGRADE = "needsUpgrade";
    private static final String UPGRADE_IN_PROGRESS = "nexusUpgradeInProgress";
    private static final String UPGRADE_ERROR = "nexusUpgradeError";
    private static final String UPGRADE_COMPLETE = "nexusUpgradeComplete";
    private static final String NEEDS_UPGRADE_PLUS_1_YEAR = "nexusNeedsUpgrade1Year";
    private static final String NEEDS_PLUS_18_MONTHS_UPGRADE = "nexusNeeds18MonthsUpgrade";
    private static final String VERSION_MISMATCH = "versionMismatch";
    private static final String UPGRADE_STATE = "dbUpgrade";
    private static final String CURRENT_STATE = "currentState";
    private static final String MESSAGE = "message";
    private final SecurityHelper securityHelper;
    private final NodeHeartbeatManager heartbeatManager;
    private final LocalDate oneYearExpirationDate;
    private final LocalDate expirationDate18Months;
    private final LoadingCache<String, ApiClusterDatabaseMigrationResultDTO> cache;

    @Inject
    public UpgradeStateContributor(SecurityHelper securityHelper, DistributedMigrationDatabaseV1ApiResource upgradeResource, NodeHeartbeatManager heartbeatManager, ApplicationVersion applicationVersion) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.heartbeatManager = (NodeHeartbeatManager)Preconditions.checkNotNull((Object)heartbeatManager);
        this.oneYearExpirationDate = LocalDate.parse(((ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion)).getBuildTimestamp().substring(0, 10)).plusYears(1L);
        this.expirationDate18Months = LocalDate.parse(((ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion)).getBuildTimestamp().substring(0, 10)).plusMonths(18L);
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(10L)).build((CacheLoader)new ProgressCacheLoader((DistributedMigrationDatabaseV1ApiResource)Preconditions.checkNotNull((Object)upgradeResource)));
    }

    public Map<String, Object> getState() {
        if (!this.securityHelper.isAllPermitted()) {
            return Collections.emptyMap();
        }
        ApiClusterDatabaseMigrationResultDTO state = (ApiClusterDatabaseMigrationResultDTO)this.cache.getUnchecked((Object)CURRENT_STATE);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(CURRENT_STATE, this.toUiState(state));
        result.put(MESSAGE, state.getMessage());
        return ImmutableMap.of((Object)UPGRADE_STATE, result);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(DistributedUpgradeEvent event) {
        this.log.debug("Clearing cache {}", (Object)event);
        this.cache.invalidateAll();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(UpgradeResultChangedEvent event) {
        this.log.debug("Clearing cache {}", (Object)event);
        this.cache.invalidateAll();
    }

    private String toUiState(ApiClusterDatabaseMigrationResultDTO state) {
        boolean versionsMatch = this.heartbeatManager.getActiveNodeHeartbeatData().stream().map(NodeHeartbeat::nodeInfo).map(nodeInfo -> nodeInfo.get("version")).distinct().count() == 1L;
        switch (state.getState()) {
            case MIGRATION_FAILED: {
                return UPGRADE_ERROR;
            }
            case MIGRATION_FAILED_RETRYABLE: {
                return UPGRADE_ERROR;
            }
            case MIGRATION_IN_PROGRESS: {
                return UPGRADE_IN_PROGRESS;
            }
            case MIGRATION_REQUIRED: {
                return versionsMatch ? NEEDS_UPGRADE : VERSION_MISMATCH;
            }
            case MIGRATION_SUCCEED: {
                return UPGRADE_COMPLETE;
            }
        }
        if (versionsMatch && this.expirationDate18Months.isBefore(LocalDate.now())) {
            return NEEDS_PLUS_18_MONTHS_UPGRADE;
        }
        if (versionsMatch && this.oneYearExpirationDate.isBefore(LocalDate.now())) {
            return NEEDS_UPGRADE_PLUS_1_YEAR;
        }
        if (!versionsMatch) {
            return VERSION_MISMATCH;
        }
        return null;
    }

    private class ProgressCacheLoader
    extends CacheLoader<String, ApiClusterDatabaseMigrationResultDTO> {
        private final DistributedMigrationDatabaseV1ApiResource upgrade;

        private ProgressCacheLoader(DistributedMigrationDatabaseV1ApiResource upgrade) {
            this.upgrade = upgrade;
        }

        public ApiClusterDatabaseMigrationResultDTO load(String key) throws Exception {
            UpgradeStateContributor.this.log.debug("Populating cache");
            return this.upgrade.getProgress();
        }
    }
}

