/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.ClusterDatabaseUpgradeResult;
import com.sonatype.nexus.distributed.internal.UpgradeData;
import com.sonatype.nexus.distributed.internal.UpgradeResultChangedEvent;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.repository.content.kv.global.ValueType;

@Named
@Singleton
public class UpgradeProgressStore
extends ComponentSupport {
    static final int TIMEOUT_MINUTES = 5;
    static final String UPGRADE_LOCK = "distributed_upgrade_lock";
    static final String UPGRADE_RESULT = "distributed_upgrade_lock.result";
    private final GlobalKeyValueStore globalKeyValueStore;
    private final EventManager eventManager;
    private final String nodeId;
    private final Clock clock;
    private final Lock upgradeLock;
    private final Cooperation2 cooperation;
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    @Inject
    public UpgradeProgressStore(GlobalKeyValueStore globalKeyValueStore, EventManager eventManager, NodeAccess nodeAccess, Clock clock, Cooperation2Factory cooperationFactory) {
        this.globalKeyValueStore = (GlobalKeyValueStore)Preconditions.checkNotNull((Object)globalKeyValueStore);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.nodeId = ((NodeAccess)Preconditions.checkNotNull((Object)nodeAccess)).getId();
        this.upgradeLock = new ReentrantLock();
        this.cooperation = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().build("distributed_upgrade_progress");
    }

    public boolean setInProgress() {
        if (this.upgradeLock.tryLock()) {
            try {
                boolean bl = (Boolean)this.cooperation.on(this::doSetInProgress).checkFunction(() -> Optional.of(Boolean.FALSE)).cooperate("upgrade_progress", new String[0]);
                return bl;
            }
            catch (IOException e) {
                this.log.warn("Failed to set in progress state", (Throwable)e);
                return false;
            }
            finally {
                this.upgradeLock.unlock();
            }
        }
        return false;
    }

    @VisibleForTesting
    boolean doSetInProgress() {
        boolean isInProgress = this.isPresent();
        if (isInProgress) {
            return false;
        }
        OffsetDateTime offsetDateTime = this.clock.clusterTime();
        this.globalKeyValueStore.setKey(new NexusKeyValue(UPGRADE_LOCK, ValueType.OBJECT, (Object)new UpgradeData(this.nodeId, offsetDateTime)));
        return true;
    }

    public void clearInProgress() {
        if (this.upgradeLock.tryLock()) {
            try {
                try {
                    this.cooperation.on(this::doClearInProgress).checkFunction(() -> Optional.of(Boolean.FALSE)).cooperate("upgrade_progress", new String[0]);
                }
                catch (IOException iOException) {
                    this.log.warn("Failed to set in progress state");
                    this.upgradeLock.unlock();
                }
            }
            finally {
                this.upgradeLock.unlock();
            }
        }
    }

    @VisibleForTesting
    boolean doClearInProgress() {
        Optional.ofNullable(this.getUpgradeData()).filter(progress -> progress.filter(upgradeData -> this.nodeId.equals(upgradeData.getNodeId())).isPresent()).ifPresent(upgradeData -> {
            boolean bl = this.globalKeyValueStore.removeKey(UPGRADE_LOCK);
        });
        return true;
    }

    public boolean isInProgress() {
        return this.isPresent();
    }

    public Optional<OffsetDateTime> getStartTime() {
        return this.getUpgradeData().map(UpgradeData::getInitiated);
    }

    private Optional<UpgradeData> getUpgradeData() {
        Optional key = this.globalKeyValueStore.getKey(UPGRADE_LOCK);
        if (key.isPresent()) {
            UpgradeData upgradeData = (UpgradeData)((NexusKeyValue)key.get()).getAsObject(this.mapper, UpgradeData.class);
            return Optional.of(upgradeData);
        }
        return Optional.empty();
    }

    private boolean isPresent() {
        return this.getUpgradeData().filter(progress -> {
            OffsetDateTime now = this.clock.clusterTime();
            OffsetDateTime initiated = progress.getInitiated();
            return initiated.isAfter(now.minusMinutes(5L));
        }).isPresent();
    }

    public Optional<ClusterDatabaseUpgradeResult> getResult() {
        return this.globalKeyValueStore.getKey(UPGRADE_RESULT).map(val -> (ClusterDatabaseUpgradeResult)val.getAsObject(this.mapper, ClusterDatabaseUpgradeResult.class));
    }

    public boolean clearResult(boolean forceClear) {
        Optional<ClusterDatabaseUpgradeResult> stored = this.getResult();
        if (forceClear || this.isRecoverableResult(stored)) {
            this.globalKeyValueStore.removeKey(UPGRADE_RESULT);
            this.eventManager.post((Object)new UpgradeResultChangedEvent());
            return true;
        }
        return !stored.isPresent();
    }

    public void setResult(ClusterDatabaseUpgradeResult result) {
        Preconditions.checkNotNull((Object)result);
        this.globalKeyValueStore.setKey(new NexusKeyValue(UPGRADE_RESULT, ValueType.OBJECT, (Object)result));
        this.eventManager.post((Object)new UpgradeResultChangedEvent());
    }

    private boolean isRecoverableResult(Optional<ClusterDatabaseUpgradeResult> result) {
        return result.map(value -> value.isSuccessful() || value.isRecoverable() != false).orElse(false);
    }
}

