/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.distributed.internal.ZeroDownTimeUpgradeModalKey;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.StateContributor;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;

@Singleton
@Named
public class UpgradeModalStateContributor
extends ComponentSupport
implements StateContributor {
    private final boolean showModal;
    private static final String ZERO_DOWNTIME_MARKETING_MODAL_CLOSED = "zeroDowntimeMarketingModalClosed";
    private final GlobalKeyValueStore globalKeyValueStore;
    private final ZeroDownTimeUpgradeModalKey zeroDownTimeUpgradeModalKey;
    private final SecurityHelper securityHelper;

    @Inject
    public UpgradeModalStateContributor(@Named(value="${zero.downtime.marketing.modal:-false}") @Named(value="${zero.downtime.marketing.modal:-false}") boolean showModal, GlobalKeyValueStore globalKeyValueStore, ZeroDownTimeUpgradeModalKey zeroDownTimeUpgradeModalKey, SecurityHelper securityHelper) {
        this.showModal = showModal;
        this.globalKeyValueStore = globalKeyValueStore;
        this.zeroDownTimeUpgradeModalKey = zeroDownTimeUpgradeModalKey;
        this.securityHelper = securityHelper;
    }

    public Map<String, Object> getState() {
        String key;
        boolean isAnonymous = AnonymousHelper.isAnonymous((Subject)this.securityHelper.subject());
        boolean modalClosed = isAnonymous ? true : (key = this.zeroDownTimeUpgradeModalKey.getZeroDowntimeMarketingModalKey()).equals("") || this.globalKeyValueStore.getKey(key).map(kv -> kv.getAsBoolean()).orElse(false) != false;
        return ImmutableMap.of((Object)"zero.downtime.marketing.modal", (Object)this.showModal, (Object)ZERO_DOWNTIME_MARKETING_MODAL_CLOSED, (Object)modalClosed);
    }
}

