/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.sonatype.nexus.distributed.internal.UpgradeModalStateApiRequest;
import com.sonatype.nexus.distributed.internal.ZeroDownTimeUpgradeModalKey;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.repository.content.kv.global.ValueType;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="internal/ui/upgradeModalOpened")
public class UpgradeModalResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_PATH = "internal/ui/upgradeModalOpened";
    private final GlobalKeyValueStore globalKeyValueStore;
    private final ZeroDownTimeUpgradeModalKey zeroDownTimeUpgradeModalKey;

    @Inject
    public UpgradeModalResource(GlobalKeyValueStore globalKeyValueStore, ZeroDownTimeUpgradeModalKey zeroDownTimeUpgradeModalKey) {
        this.globalKeyValueStore = globalKeyValueStore;
        this.zeroDownTimeUpgradeModalKey = zeroDownTimeUpgradeModalKey;
    }

    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void updateZeroDowntimeMarketingModalState(@NotNull @Valid UpgradeModalStateApiRequest upgradeModalStateApiRequest) {
        NexusKeyValue kv = new NexusKeyValue();
        kv.setKey(this.zeroDownTimeUpgradeModalKey.getZeroDowntimeMarketingModalKey());
        kv.setType(ValueType.BOOLEAN);
        kv.setValue((Object)upgradeModalStateApiRequest.getZeroDowntimeMarketingModalClosed());
        this.globalKeyValueStore.setKey(kv);
    }
}

