/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccessSupport;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.node.datastore.NodeIdStore;

@Singleton
@Priority(value=0x7FFFFFFF)
@Named(value="ephemeral")
public class EphemeralNodeAccess
extends NodeAccessSupport {
    public static final String EPHEMERAL_NODE_ACCESS = "ephemeral";
    private static final String NODE_ID = UUID.randomUUID().toString();
    private final NodeIdStore nodeIdStore;
    private final Provider<NodeHeartbeatStore> nodeHeartbeatStore;

    @Inject
    public EphemeralNodeAccess(NodeIdStore nodeIdStore, Provider<NodeHeartbeatStore> nodeHeartbeatStore) {
        this.nodeIdStore = (NodeIdStore)Preconditions.checkNotNull((Object)nodeIdStore);
        this.nodeHeartbeatStore = (Provider)Preconditions.checkNotNull(nodeHeartbeatStore);
    }

    @Guarded(by={"STARTED"})
    public String getId() {
        return NODE_ID;
    }

    public boolean isClustered() {
        return true;
    }

    @Guarded(by={"STARTED"})
    public String getClusterId() {
        return this.nodeIdStore.getOrCreate();
    }

    public boolean isOldestNode() {
        return true;
    }

    public Set<String> getMemberIds() {
        return Collections.unmodifiableSet(this.getMemberAliases().keySet());
    }

    public Map<String, String> getMemberAliases() {
        Map<String, String> memberAliases = ((NodeHeartbeatStore)this.nodeHeartbeatStore.get()).getActiveNodes().stream().map(data -> data.nodeInfo().get("nodeId").toString()).collect(Collectors.toMap(String::toString, String::toString));
        memberAliases.put(NODE_ID, NODE_ID);
        return memberAliases;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "id='" + NODE_ID + '\'' + '}';
    }
}

