/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.distributed.event.DistributedUpgradeEvent;
import com.sonatype.nexus.distributed.event.DistributedUpgradeVersionRequestEvent;
import com.sonatype.nexus.distributed.internal.ClusterDatabaseUpgradeResult;
import com.sonatype.nexus.distributed.internal.DistributedEventPollInterval;
import com.sonatype.nexus.distributed.internal.UpgradeProgressStore;
import com.sonatype.nexus.distributed.internal.UpgradeRequestException;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.flywaydb.core.api.MigrationVersion;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.node.datastore.NodeHeartbeat;
import org.sonatype.nexus.node.datastore.NodeHeartbeatManager;
import org.sonatype.nexus.upgrade.UpgradeService;
import org.sonatype.nexus.upgrade.datastore.UpgradeManager;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeCompletedEvent;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeEventSupport;
import org.sonatype.nexus.upgrade.datastore.events.UpgradeFailedEvent;

@Named
@FeatureFlag(name="nexus.datastore.clustered.enabled")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.UPGRADE)
@Singleton
public class ClusteredUpgradeServiceImpl
extends StateGuardLifecycleSupport
implements UpgradeService,
EventAware {
    private static final long SECOND_IN_MILLISECONDS = 1000L;
    private static final String BASELINE_VERSION = "2.0";
    private final NodeHeartbeatManager nodeHeartbeatManager;
    private final String applicationVersion;
    private final EventManager eventManager;
    private final UpgradeManager upgradeManager;
    private final UpgradeProgressStore upgradeProgressStore;
    private final long timeoutInMs;
    private final ExecutorService executorService;

    @Inject
    public ClusteredUpgradeServiceImpl(ApplicationVersion applicationVersion, EventManager eventManager, UpgradeManager upgradeManager, UpgradeProgressStore upgradeProgressStore, NodeHeartbeatManager nodeHeartbeatManager, DistributedEventPollInterval pollInterval) {
        this.applicationVersion = ((ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion)).getVersion();
        this.nodeHeartbeatManager = (NodeHeartbeatManager)Preconditions.checkNotNull((Object)nodeHeartbeatManager);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.upgradeManager = (UpgradeManager)Preconditions.checkNotNull((Object)upgradeManager);
        this.upgradeProgressStore = (UpgradeProgressStore)((Object)Preconditions.checkNotNull((Object)((Object)upgradeProgressStore)));
        this.timeoutInMs = ((DistributedEventPollInterval)Preconditions.checkNotNull((Object)pollInterval)).get().getSeconds() * 2L * 1000L;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    protected void doStart() throws Exception {
        if (this.upgradeProgressStore.isInProgress()) {
            this.log.error("Nodes can not be started whilst an upgrade is in progress, shutting down");
            System.exit(1);
        }
        if (!this.upgradeManager.getCurrentVersion().isPresent()) {
            this.log.info("No current database stage detected. Upgrading during startup.");
            this.upgradeManager.migrate();
        }
        if (this.isSchemaVersionKnown()) {
            this.log.info("The database schema is further ahead than the migrations this instance knows about");
            System.exit(2);
        }
        this.upgradeManager.checkBaseline(BASELINE_VERSION);
    }

    private boolean isSchemaVersionKnown() {
        return this.upgradeManager.getCurrentVersion().isPresent() && this.upgradeManager.getMaxMigrationVersion().isPresent() && ((MigrationVersion)this.upgradeManager.getCurrentVersion().get()).isNewerThan(((MigrationVersion)this.upgradeManager.getMaxMigrationVersion().get()).getVersion());
    }

    public void initiate(String user) throws UpgradeRequestException {
        this.log.debug("Received a request to start an upgrade by {}", (Object)user);
        Optional<String> nonRecoverableErrorMessage = this.upgradeProgressStore.getResult().filter(ClusteredUpgradeServiceImpl::isNonRecoverableError).map(ClusterDatabaseUpgradeResult::getMessage);
        if (nonRecoverableErrorMessage.isPresent()) {
            this.log.warn("Unable to initiate upgrade due to unrecoverable failure in previous attempt: {}", (Object)nonRecoverableErrorMessage.get());
            throw new UpgradeRequestException("A previous upgrade failed and cannot be recovered. Please contact support for assistance.");
        }
        if (!this.upgradeProgressStore.setInProgress()) {
            this.log.debug("Unable to initiate upgrade, already in progress");
            throw new UpgradeRequestException("Previous upgrade is still in progress");
        }
        this.startUpgrade(user);
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(DistributedUpgradeVersionRequestEvent event) {
        this.log.debug("Received a version request");
        this.nodeHeartbeatManager.writeHeartbeat();
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(DistributedUpgradeEvent event) {
        if (this.log.isDebugEnabled() && EventHelper.isReplicating()) {
            ClusterDatabaseUpgradeResult result = event.getResult();
            this.log.debug("Remote upgrade successful:{} recoverable:{} message:{}", new Object[]{result.isSuccessful(), result.isRecoverable(), result.getMessage()});
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(UpgradeEventSupport event) {
        if (!this.log.isDebugEnabled() || !EventHelper.isReplicating()) {
            return;
        }
        if (event instanceof UpgradeFailedEvent) {
            this.log.debug("Remote upgrade failed: {}", (Object)((UpgradeFailedEvent)event).getErrorMessage());
        } else if (event instanceof UpgradeCompletedEvent) {
            this.log.debug("Remote upgrade completed: {}", (Object)event.getSchemaVersion());
        } else {
            this.log.debug("Remote upgrade started");
        }
    }

    private void startUpgrade(String user) {
        this.eventManager.post((Object)new DistributedUpgradeVersionRequestEvent());
        this.executorService.submit(() -> this.checkForCompletion(user));
    }

    private static boolean isNonRecoverableError(ClusterDatabaseUpgradeResult result) {
        return result.isError() && result.isRecoverable() == false;
    }

    /*
     * Loose catch block
     */
    void checkForCompletion(String user) {
        block19: {
            long startTime = System.currentTimeMillis();
            ClusterDatabaseUpgradeResult result = null;
            try {
                while (true) {
                    if (System.currentTimeMillis() - startTime > this.timeoutInMs) {
                        throw new TimeoutException();
                    }
                    Collection activeNodeHeartbeatData = this.nodeHeartbeatManager.getActiveNodeHeartbeatData();
                    if (this.haveAllResponded(activeNodeHeartbeatData)) {
                        if (this.checkAllVersionsReceivedAndMatch(activeNodeHeartbeatData)) {
                            this.log.debug("Starting upgrade");
                            Stopwatch started = Stopwatch.createStarted();
                            this.upgradeManager.migrate(user, (Collection)activeNodeHeartbeatData.stream().map(NodeHeartbeat::nodeInfo).map(nodeInfo -> nodeInfo.get("nodeId").toString()).collect(Collectors.toList()));
                            this.log.debug("Upgrade complete in {}", (Object)started.elapsed());
                            result = new ClusterDatabaseUpgradeResult("Upgrade complete");
                        } else {
                            this.log.info("Not all nodes are on the same version is the initiating node");
                            result = new ClusterDatabaseUpgradeResult("Not all nodes are on the same version", true);
                            this.eventManager.post((Object)new DistributedUpgradeEvent(result));
                        }
                        break;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                this.log.warn("Upgrade check interrupted", (Throwable)e);
                result = new ClusterDatabaseUpgradeResult("Upgrade check interrupted", true);
                this.eventManager.post((Object)new DistributedUpgradeEvent(result));
                if (result != null) {
                    this.upgradeProgressStore.setResult(result);
                }
                this.upgradeProgressStore.clearInProgress();
                break block19;
            }
            catch (TimeoutException timeoutException) {
                this.log.warn("Timed out waiting for responses from all other nodes");
                result = new ClusterDatabaseUpgradeResult("Timed out waiting for responses from all other nodes", true);
                this.eventManager.post((Object)new DistributedUpgradeEvent(result));
                if (result != null) {
                    this.upgradeProgressStore.setResult(result);
                }
                this.upgradeProgressStore.clearInProgress();
                break block19;
            }
            catch (Exception e) {
                this.log.warn("Failed to migrate", (Throwable)e);
                result = new ClusterDatabaseUpgradeResult("An error occurred during migration: " + e.getMessage(), false);
                if (result != null) {
                    this.upgradeProgressStore.setResult(result);
                }
                this.upgradeProgressStore.clearInProgress();
                break block19;
                {
                    catch (Throwable throwable) {
                        if (result != null) {
                            this.upgradeProgressStore.setResult(result);
                        }
                        this.upgradeProgressStore.clearInProgress();
                        throw throwable;
                    }
                }
            }
            if (result != null) {
                this.upgradeProgressStore.setResult(result);
            }
            this.upgradeProgressStore.clearInProgress();
        }
    }

    private boolean haveAllResponded(Collection<NodeHeartbeat> nodeVersions) {
        Optional<OffsetDateTime> startTime = this.upgradeProgressStore.getStartTime();
        return startTime.filter(offsetDateTime -> nodeVersions.stream().allMatch(node -> node.heartbeatTime().isAfter((OffsetDateTime)offsetDateTime))).isPresent();
    }

    private boolean checkAllVersionsReceivedAndMatch(Collection<NodeHeartbeat> nodeVersions) {
        return nodeVersions.stream().allMatch(node -> {
            Map nodeInfo = node.nodeInfo();
            return nodeInfo.containsKey("version") && nodeInfo.get("version").toString().equals(this.applicationVersion);
        });
    }

    public boolean requiresMigration() {
        return this.upgradeManager.requiresMigration();
    }

    public boolean isInProgress() {
        return this.upgradeProgressStore.isInProgress();
    }

    public Optional<ClusterDatabaseUpgradeResult> getClusterDatabaseUpgradeResult() {
        return this.upgradeProgressStore.getResult();
    }

    public boolean clearResult(boolean forceClear) {
        return this.upgradeProgressStore.clearResult(forceClear);
    }
}

