/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.event;

import com.sonatype.nexus.distributed.event.DistributedEventData;
import com.sonatype.nexus.distributed.internal.event.store.DistributedEventDAO;
import java.time.OffsetDateTime;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class DistributedEventStore
extends ConfigStoreSupport<DistributedEventDAO> {
    @Inject
    public DistributedEventStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Transactional
    public void publishEvent(DistributedEventData eventData) {
        ((DistributedEventDAO)this.dao()).createEvent(eventData);
    }

    @Transactional
    public Continuation<DistributedEventData> readRemoteEvents(String nodeId, int limit, @Nullable String continuationToken, @Nullable OffsetDateTime nodeStartTime) {
        this.log.debug("Fetching distributed events where source is not {}", (Object)nodeId);
        return ((DistributedEventDAO)this.dao()).readRemoteEvents(nodeId, limit, continuationToken, nodeStartTime);
    }

    @Transactional
    public void cleanupOldEvents(int minutesAgo) {
        this.log.debug("Deleting distributed events older than {} minutes.", (Object)minutesAgo);
        ((DistributedEventDAO)this.dao()).cleanupOldEvents(minutesAgo);
        this.log.debug("Deleted distributed events older than {} minutes.", (Object)minutesAgo);
    }
}

