/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.cooperation;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.cooperation.CooperationLock;
import com.sonatype.nexus.distributed.cooperation.CooperationStore;
import com.sonatype.nexus.distributed.internal.cooperation.DistributedCooperationRegistry;
import com.sonatype.nexus.distributed.internal.cooperation.store.CooperationLockData;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.datastore.api.DataAccessException;

@Named
@Singleton
public class DatabaseDistributedCooperationRegistry
extends ComponentSupport
implements DistributedCooperationRegistry {
    private static final String INVALID_DURATION_ERROR_MSG = "Invalid duration seconds specified. It must be positive.";
    private final CooperationStore store;
    private final NodeAccess nodeAccess;

    @Inject
    public DatabaseDistributedCooperationRegistry(CooperationStore store, NodeAccess nodeAccess) {
        this.store = (CooperationStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    @Override
    public CooperationLock lockCooperationKey(String cooperationKey, Duration duration) {
        Preconditions.checkState((duration.getSeconds() > 0L ? 1 : 0) != 0, (Object)INVALID_DURATION_ERROR_MSG);
        CooperationLockData data = new CooperationLockData();
        data.setCooperationKey(cooperationKey);
        data.setAcquired(true);
        data.setDurationSeconds(duration.getSeconds());
        data.setNodeId(this.nodeAccess.getId());
        if (this.acquire(data)) {
            return data;
        }
        return this.getLockOwnerOrRetryLocking(cooperationKey, data);
    }

    private CooperationLock getLockOwnerOrRetryLocking(String cooperationKey, CooperationLockData data) {
        return this.store.readCooperationLock(cooperationKey).orElseGet(() -> {
            if (this.acquire(data)) {
                return data;
            }
            return this.store.readCooperationLock(cooperationKey).orElseGet(() -> this.dummyCooperationLock(cooperationKey));
        });
    }

    private CooperationLockData dummyCooperationLock(String cooperationKey) {
        CooperationLockData cooperationLockData = new CooperationLockData();
        cooperationLockData.setAcquired(false);
        cooperationLockData.setCooperationKey(cooperationKey);
        cooperationLockData.setNodeId("dummy");
        return cooperationLockData;
    }

    @Override
    public void releaseCooperationKey(String cooperationKey) {
        String nodeId = this.nodeAccess.getId();
        this.log.debug("Attempting to release lock for node id: {}, cooperation key: {}", (Object)nodeId, (Object)cooperationKey);
        int count = this.store.releaseCooperationKey(cooperationKey, nodeId);
        this.log.debug("Released {} lock for node id: {}, cooperation key: {}", new Object[]{count, nodeId, cooperationKey});
    }

    @Override
    public boolean canLockCooperationKey(String cooperationKey) {
        return this.store.canAcquireLock(cooperationKey);
    }

    private boolean acquire(CooperationLockData data) {
        try {
            return this.store.acquire(data);
        }
        catch (DataAccessException e) {
            this.log.error("Attempt to acquire failed for {}", (Object)data.getNodeId(), (Object)e);
            return false;
        }
    }
}

