/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.cooperation;

import com.sonatype.nexus.distributed.cooperation.CooperationLock;
import com.sonatype.nexus.distributed.internal.cooperation.store.CooperationDAO;
import com.sonatype.nexus.distributed.internal.cooperation.store.CooperationLockData;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.SerializedAccessException;
import org.sonatype.nexus.transaction.TransactionIsolation;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class CooperationStore
extends ConfigStoreSupport<CooperationDAO> {
    @Inject
    public CooperationStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Transactional
    public Optional<CooperationLock> readCooperationLock(String cooperationKey) {
        return ((CooperationDAO)this.dao()).readCooperationLock(cooperationKey);
    }

    public boolean acquire(CooperationLockData data) {
        block5: {
            block4: {
                try {
                    if (this.reassign(data) <= 0) break block4;
                    this.log.trace("Reassigned expired cooperation {}", (Object)data.getCooperationKey());
                    return true;
                }
                catch (SerializedAccessException serializedAccessException) {
                    this.log.warn("Retries exceeded accessing distributed cooperation");
                    return false;
                }
            }
            if (this.insert(data) <= 0) break block5;
            this.log.trace("Acquired cooperation lock. Node id: {}, cooperation key: {}", (Object)data.getNodeId(), (Object)data.getCooperationKey());
            return true;
        }
        this.log.trace("Failed to insert lock. Node id: {}, cooperation key: {}", (Object)data.getNodeId(), (Object)data.getCooperationKey());
        return false;
    }

    @Transactional(retryOn={SerializedAccessException.class}, isolation=TransactionIsolation.SERIALIZABLE)
    protected int reassign(CooperationLockData data) {
        return ((CooperationDAO)this.dao()).reassignExpiredCooperationLock(data);
    }

    @Transactional(retryOn={SerializedAccessException.class}, isolation=TransactionIsolation.SERIALIZABLE)
    protected int insert(CooperationLockData data) {
        return ((CooperationDAO)this.dao()).insertCooperationLock(data);
    }

    @Transactional
    public int releaseCooperationKey(String cooperationKey, String nodeId) {
        return ((CooperationDAO)this.dao()).removeCooperationLock(cooperationKey, nodeId);
    }

    @Transactional
    public boolean canAcquireLock(String cooperationKey) {
        return !((CooperationDAO)this.dao()).isActiveCooperation(cooperationKey).isPresent();
    }
}

