/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.cache;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.sqlcache.store.CacheStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class SqlCacheService
extends LifecycleSupport {
    private final CacheStore store;
    private final PeriodicJobService periodicJobService;
    private final int clearIntervalMin;
    private PeriodicJobService.PeriodicJob clearTask;

    @Inject
    public SqlCacheService(CacheStore store, PeriodicJobService periodicJobService, @Named(value="${nexus.datastore.sql.cache.clearInterval:-60}") @Named(value="${nexus.datastore.sql.cache.clearInterval:-60}") int clearIntervalMin) {
        this.store = (CacheStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        Preconditions.checkState((clearIntervalMin > 0 ? 1 : 0) != 0, (Object)"Clear time interval should be positive");
        this.clearIntervalMin = clearIntervalMin;
    }

    protected void doStart() throws Exception {
        this.log.debug("Starting SQL cache cleanup task with time interval: {} minutes", (Object)this.clearIntervalMin);
        this.periodicJobService.startUsing();
        this.clearTask = this.periodicJobService.schedule(this::clearStale, this.clearIntervalMin * 60);
    }

    protected void doStop() throws Exception {
        this.clearTask.cancel();
        this.periodicJobService.stopUsing();
    }

    private void clearStale() {
        this.log.debug("Removing stale cache data");
        this.store.removeStale();
    }
}

