/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.cache.SqlCache;
import com.sonatype.nexus.distributed.internal.sqlcache.store.CacheStore;
import javax.annotation.Priority;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cache.CacheManager;
import org.sonatype.nexus.cache.NexusCache;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class SqlCacheManager<K, V>
extends ComponentSupport
implements CacheManager<K, V> {
    private final CacheStore store;
    private final ObjectMapper mapper;

    @Inject
    public SqlCacheManager(CacheStore store, ObjectMapper mapper) {
        this.store = (CacheStore)((Object)Preconditions.checkNotNull((Object)((Object)store)));
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
    }

    public NexusCache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType, Duration expiryAfter) {
        this.log.debug("Creating the {} cache with expiry duration: {}", (Object)cacheName, (Object)expiryAfter);
        return new SqlCache<K, V>(this.store, cacheName, expiryAfter, this.mapper, keyType, valueType);
    }

    public void destroyCache(String cacheName) {
        this.store.removeAll(cacheName);
    }
}

