/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.distributed.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.distributed.internal.sqlcache.store.CacheStore;
import java.io.IOException;
import java.util.Optional;
import javax.cache.expiry.Duration;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.ArrayUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cache.NexusCache;

public class SqlCache<K, V>
extends ComponentSupport
implements NexusCache<K, V> {
    private final CacheStore cacheStore;
    private final String cacheName;
    private final Duration expiryAfter;
    private final ObjectMapper mapper;
    private final Class<K> keyType;
    private final Class<V> valueType;

    public SqlCache(CacheStore cacheStore, String cacheName, Duration expiryAfter, ObjectMapper mapper, Class<K> keyType, Class<V> valueType) {
        this.cacheStore = (CacheStore)((Object)Preconditions.checkNotNull((Object)((Object)cacheStore)));
        this.cacheName = (String)Preconditions.checkNotNull((Object)cacheName);
        this.expiryAfter = (Duration)Preconditions.checkNotNull((Object)expiryAfter);
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
        this.keyType = (Class)Preconditions.checkNotNull(keyType);
        this.valueType = (Class)Preconditions.checkNotNull(valueType);
    }

    public Optional<V> get(@NotNull K key) {
        try {
            this.log.trace("Trying to access cache '{}'", (Object)this.cacheName);
            Object[] keyBytes = ArrayUtils.toObject((byte[])this.mapper.writerFor(this.keyType).writeValueAsBytes(key));
            Optional<Byte[]> valueBytes = this.cacheStore.get(this.cacheName, (Byte[])keyBytes);
            if (valueBytes.isPresent()) {
                this.log.trace("The cached value was found using the supplied key. \nKey - {}\nValue - {}", (Object)keyBytes, valueBytes);
                return Optional.ofNullable(this.mapper.readerFor(this.valueType).readValue(ArrayUtils.toPrimitive((Byte[])valueBytes.get())));
            }
            this.log.trace("The cached value wasn't found using the supplied key. \nKey - {}", keyBytes);
            return Optional.empty();
        }
        catch (IOException e) {
            this.logError("An error occurred during pulling cache item.", e);
            return Optional.empty();
        }
    }

    public void put(@NotNull K key, @NotNull V value) {
        try {
            Byte[] keyBytes = ArrayUtils.toObject((byte[])this.mapper.writerFor(this.keyType).writeValueAsBytes(key));
            Byte[] valueBytes = ArrayUtils.toObject((byte[])this.mapper.writerFor(this.valueType).writeValueAsBytes(value));
            this.cacheStore.set(this.cacheName, keyBytes, valueBytes, this.expiryAfter);
        }
        catch (JsonProcessingException e) {
            this.logError("An error occurred during pushing cache item.", (IOException)((Object)e));
        }
    }

    public void remove(@NotNull K key) {
        try {
            Byte[] keyBytes = ArrayUtils.toObject((byte[])this.mapper.writerFor(this.keyType).writeValueAsBytes(key));
            this.cacheStore.remove(this.cacheName, keyBytes);
        }
        catch (JsonProcessingException e) {
            this.logError("An error occurred during deleting cache item.", (IOException)((Object)e));
        }
    }

    public void removeAll() {
        this.cacheStore.removeAll(this.cacheName);
    }

    private void logError(String message, IOException e) {
        if (this.log.isDebugEnabled()) {
            this.log.error(message, (Throwable)e);
        } else {
            this.log.error("{}. Cause: {}", (Object)message, (Object)e.getMessage());
        }
    }
}

