/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.search.elasticsearch;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.sonatype.nexus.cleanup.internal.search.elasticsearch.CriteriaAppender;

public abstract class LessThanTimeOrNeverDownloadedCriteriaAppender
implements CriteriaAppender {
    private static final String NOW_MINUS_SECONDS = "now-%ss";
    private final String field;

    public LessThanTimeOrNeverDownloadedCriteriaAppender(String field) {
        this.field = field;
    }

    @Override
    public void append(BoolQueryBuilder query, String value) {
        BoolQueryBuilder neverDownloadDownloadBuilder = QueryBuilders.boolQuery();
        neverDownloadDownloadBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.field));
        neverDownloadDownloadBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"lastBlobUpdated").lte(String.format(NOW_MINUS_SECONDS, value)));
        RangeQueryBuilder lastDownloadRangeBuilder = QueryBuilders.rangeQuery((String)this.field).lte(String.format(NOW_MINUS_SECONDS, value));
        BoolQueryBuilder lastDownloadShouldBuilder = QueryBuilders.boolQuery();
        lastDownloadShouldBuilder.must((QueryBuilder)lastDownloadRangeBuilder);
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        filterBuilder.should((QueryBuilder)lastDownloadShouldBuilder);
        filterBuilder.should((QueryBuilder)neverDownloadDownloadBuilder);
        query.filter((QueryBuilder)filterBuilder);
    }
}

