/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.config.CleanupPolicyConfiguration;
import org.sonatype.nexus.cleanup.content.CleanupPolicyCreatedEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyDeletedEvent;
import org.sonatype.nexus.cleanup.content.CleanupPolicyUpdatedEvent;
import org.sonatype.nexus.cleanup.internal.preview.CSVCleanupPreviewContentWriter;
import org.sonatype.nexus.cleanup.internal.rest.CleanupPolicyFormatXO;
import org.sonatype.nexus.cleanup.internal.rest.PreviewRequestXO;
import org.sonatype.nexus.cleanup.preview.CleanupPreviewHelper;
import org.sonatype.nexus.cleanup.rest.CleanupPolicyRequestValidator;
import org.sonatype.nexus.cleanup.rest.CleanupPolicyXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyCriteria;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyPreviewXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyReleaseType;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.CleanupDryRunEvent;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.query.PageResult;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/internal/cleanup-policies")
public class CleanupPolicyResource
extends ComponentSupport
implements Resource {
    protected static final String RESOURCE_URI = "/internal/cleanup-policies";
    protected static final String MODE_DELETE = "delete";
    private static final int PREVIEW_ITEM_COUNT = 50;
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final List<String> formatNames;
    private final List<Format> formats;
    private final Map<String, CleanupPolicyConfiguration> cleanupFormatConfigurationMap;
    private final CleanupPolicyConfiguration defaultCleanupFormatConfiguration;
    private final Provider<CleanupPreviewHelper> cleanupPreviewHelper;
    private final RepositoryManager repositoryManager;
    private final EventManager eventManager;
    private final boolean isPreviewEnabled;
    private final CSVCleanupPreviewContentWriter csvCleanupPreviewContentWriter;
    private final Collection<CleanupPolicyRequestValidator> cleanupPolicyValidators;

    @Inject
    public CleanupPolicyResource(CleanupPolicyStorage cleanupPolicyStorage, List<Format> formats, Map<String, CleanupPolicyConfiguration> cleanupFormatConfigurationMap, Provider<CleanupPreviewHelper> cleanupPreviewHelper, RepositoryManager repositoryManager, EventManager eventManager, @Named(value="${nexus.cleanup.preview.enabled:-true}") @Named(value="${nexus.cleanup.preview.enabled:-true}") boolean isPreviewEnabled, CSVCleanupPreviewContentWriter csvCleanupPreviewContentWriter, Collection<CleanupPolicyRequestValidator> cleanupPolicyValidators) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.formats = (List)Preconditions.checkNotNull(formats);
        this.formatNames = formats.stream().map(Format::getValue).collect(Collectors.toList());
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.formatNames.add("*");
        this.cleanupFormatConfigurationMap = (Map)Preconditions.checkNotNull(cleanupFormatConfigurationMap);
        this.defaultCleanupFormatConfiguration = (CleanupPolicyConfiguration)Preconditions.checkNotNull((Object)cleanupFormatConfigurationMap.get("default"));
        this.cleanupPreviewHelper = (Provider)Preconditions.checkNotNull(cleanupPreviewHelper);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.isPreviewEnabled = isPreviewEnabled;
        this.csvCleanupPreviewContentWriter = (CSVCleanupPreviewContentWriter)((Object)Preconditions.checkNotNull((Object)((Object)csvCleanupPreviewContentWriter)));
        this.cleanupPolicyValidators = (Collection)Preconditions.checkNotNull(cleanupPolicyValidators);
    }

    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    public List<CleanupPolicyXO> get(@QueryParam(value="format") String format) {
        List policies = StringUtils.isBlank((CharSequence)format) || format.equals("*") ? this.cleanupPolicyStorage.getAll() : this.cleanupPolicyStorage.getAllByFormat(format);
        return policies.stream().map(cleanupPolicy -> CleanupPolicyXO.fromCleanupPolicy(cleanupPolicy, (int)this.repositoryManager.browseForCleanupPolicy(cleanupPolicy.getName()).count())).sorted(Comparator.comparing(CleanupPolicyXO::getName)).collect(Collectors.toList());
    }

    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate(groups={Create.class, Default.class})
    public CleanupPolicyXO add(@Valid CleanupPolicyXO cleanupPolicyXO) {
        if (!this.formatNames.contains(cleanupPolicyXO.getFormat())) {
            throw new ValidationErrorsException("format", "specified format " + cleanupPolicyXO.getFormat() + " is not valid.");
        }
        for (CleanupPolicyRequestValidator validator : this.cleanupPolicyValidators) {
            validator.validate(cleanupPolicyXO);
        }
        CleanupPolicyXO cleanupXO = CleanupPolicyXO.fromCleanupPolicy(this.cleanupPolicyStorage.add(this.toCleanupPolicy(cleanupPolicyXO)), 0);
        this.eventManager.post((Object)new CleanupPolicyCreatedEvent(this.toCleanupPolicy(cleanupXO)));
        return cleanupXO;
    }

    @GET
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public CleanupPolicyXO getByName(@PathParam(value="name") String name) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new NotFoundException("Cleanup policy " + name + " not found.");
        }
        return CleanupPolicyXO.fromCleanupPolicy(cleanupPolicy, (int)this.repositoryManager.browseForCleanupPolicy(name).count());
    }

    @PUT
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Validate(groups={Update.class, Default.class})
    public CleanupPolicyXO edit(@PathParam(value="name") String name, @NotNull @Valid CleanupPolicyXO cleanupPolicyXO) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new NotFoundException("Cleanup policy " + cleanupPolicyXO.getName() + " not found.");
        }
        if (!this.formatNames.contains(cleanupPolicyXO.getFormat())) {
            throw new ValidationErrorsException("format", "specified format " + cleanupPolicyXO.getFormat() + " is not valid.");
        }
        int inUseCount = (int)this.repositoryManager.browseForCleanupPolicy(name).count();
        if (!cleanupPolicyXO.getFormat().equals("*") && !cleanupPolicy.getFormat().equals(cleanupPolicyXO.getFormat()) && inUseCount > 0) {
            throw new ValidationErrorsException("format", "You cannot change the format of a policy that is in use.");
        }
        for (CleanupPolicyRequestValidator validator : this.cleanupPolicyValidators) {
            validator.validate(cleanupPolicyXO);
        }
        cleanupPolicy.setNotes(cleanupPolicyXO.getNotes());
        cleanupPolicy.setFormat(cleanupPolicyXO.getFormat());
        cleanupPolicy.setCriteria(this.toCriteriaMap(cleanupPolicyXO));
        CleanupPolicyXO cleanupXO = CleanupPolicyXO.fromCleanupPolicy(this.cleanupPolicyStorage.update(cleanupPolicy), inUseCount);
        this.eventManager.post((Object)new CleanupPolicyUpdatedEvent(cleanupPolicy));
        return cleanupXO;
    }

    @DELETE
    @Path(value="{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void delete(@PathParam(value="name") String name) {
        CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(name);
        if (cleanupPolicy == null) {
            throw new NotFoundException("Cleanup policy " + name + " not found.");
        }
        this.cleanupPolicyStorage.remove(cleanupPolicy);
        this.eventManager.post((Object)new CleanupPolicyDeletedEvent(cleanupPolicy));
    }

    @GET
    @Path(value="criteria/formats")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public List<CleanupPolicyFormatXO> getCriteriaForFormats() {
        ArrayList<CleanupPolicyFormatXO> criteriaByFormat = new ArrayList<CleanupPolicyFormatXO>();
        this.formats.forEach(format -> {
            CleanupPolicyConfiguration config = this.cleanupFormatConfigurationMap.get(format.getValue());
            if (config == null) {
                config = this.defaultCleanupFormatConfiguration;
            }
            criteriaByFormat.add(new CleanupPolicyFormatXO(format.getValue(), format.getValue(), config.getConfiguration().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet())));
        });
        criteriaByFormat.sort(Comparator.comparing(CleanupPolicyFormatXO::getName));
        criteriaByFormat.add(0, new CleanupPolicyFormatXO("*", "All Formats", this.defaultCleanupFormatConfiguration.getConfiguration().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet())));
        return criteriaByFormat;
    }

    @POST
    @Path(value="preview/components")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public PageResult<ComponentXO> previewContent(PreviewRequestXO request) {
        Repository repository = this.repositoryManager.get(request.getRepository());
        if (repository == null) {
            throw new NotFoundException("Repository " + request.getRepository() + " not found.");
        }
        CleanupPolicyPreviewXO xo = new CleanupPolicyPreviewXO();
        CleanupPolicyCriteria criteria = new CleanupPolicyCriteria(request.getCriteriaLastBlobUpdated(), request.getCriteriaLastDownloaded(), request.getCriteriaReleaseType(), request.getCriteriaAssetRegex(), request.getCriteriaRetain(), request.getCriteriaSortBy());
        xo.setCriteria(criteria);
        QueryOptions options = new QueryOptions(request.getFilter(), "name", "asc", Integer.valueOf(0), Integer.valueOf(50));
        try {
            PagedResponse<ComponentXO> response = ((CleanupPreviewHelper)this.cleanupPreviewHelper.get()).getSearchResults(xo, repository, options);
            return new PageResult(response.getTotal(), new ArrayList((Collection)response.getData()));
        }
        catch (IllegalArgumentException e) {
            throw new ValidationErrorsException("filter", e.getMessage());
        }
    }

    @GET
    @Path(value="preview/components/csv")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @Produces(value={"application/octet-stream"})
    @Timed
    public Response previewContentCsv(@QueryParam(value="name") @Nullable String name, @QueryParam(value="repository") String repositoryName, @QueryParam(value="criteriaLastBlobUpdated") @Nullable Integer criteriaLastBlobUpdated, @QueryParam(value="criteriaLastDownloaded") @Nullable Integer criteriaLastDownloaded, @QueryParam(value="criteriaReleaseType") @Nullable CleanupPolicyReleaseType criteriaReleaseType, @QueryParam(value="criteriaAssetRegex") @Nullable String criteriaAssetRegex, @QueryParam(value="criteriaRetain") @Nullable Integer criteriaRetain, @QueryParam(value="criteriaSortBy") @Nullable String criteriaSortBy) {
        if (!this.isPreviewEnabled) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository == null) {
            throw new NotFoundException("Repository " + repositoryName + " not found.");
        }
        CleanupPolicyXO cleanupPolicyXO = new CleanupPolicyXO();
        cleanupPolicyXO.setName(name);
        cleanupPolicyXO.setFormat(repository.getFormat().getValue());
        if (criteriaLastBlobUpdated != null) {
            cleanupPolicyXO.setCriteriaLastBlobUpdated(criteriaLastBlobUpdated.longValue());
        }
        if (criteriaLastDownloaded != null) {
            cleanupPolicyXO.setCriteriaLastDownloaded(criteriaLastDownloaded.longValue());
        }
        cleanupPolicyXO.setCriteriaReleaseType(criteriaReleaseType);
        cleanupPolicyXO.setCriteriaAssetRegex(criteriaAssetRegex);
        cleanupPolicyXO.setRetain(criteriaRetain);
        cleanupPolicyXO.setSortBy(criteriaSortBy);
        for (CleanupPolicyRequestValidator validator : this.cleanupPolicyValidators) {
            validator.validate(cleanupPolicyXO);
        }
        HashMap<String, Long> cleanupDryRunXO = new HashMap<String, Long>();
        cleanupDryRunXO.put("startedAt_in_milliseconds", System.currentTimeMillis());
        StreamingOutput streamingOutput = output -> {
            CleanupPolicyPreviewXO xo = new CleanupPolicyPreviewXO();
            xo.setRepositoryName(repositoryName);
            CleanupPolicyCriteria criteria = new CleanupPolicyCriteria(criteriaLastBlobUpdated, criteriaLastDownloaded, criteriaReleaseType, criteriaAssetRegex, criteriaRetain, criteriaSortBy);
            xo.setCriteria(criteria);
            Stream<ComponentXO> components = ((CleanupPreviewHelper)this.cleanupPreviewHelper.get()).getSearchResultsStream(xo, repository, null);
            this.csvCleanupPreviewContentWriter.write(repository, components, output);
            cleanupDryRunXO.put("finishedAt_in_milliseconds", System.currentTimeMillis());
            this.eventManager.post((Object)new CleanupDryRunEvent(cleanupDryRunXO));
        };
        String policyName = name == null ? "CleanupPreview" : name;
        String filename = String.valueOf(policyName) + "-" + repository.getName() + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss")) + ".csv";
        return Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)("attachment; filename=" + filename)).build();
    }

    private CleanupPolicy toCleanupPolicy(CleanupPolicyXO cleanupPolicyXO) {
        CleanupPolicy policy = this.cleanupPolicyStorage.newCleanupPolicy();
        policy.setName(cleanupPolicyXO.getName());
        policy.setNotes(cleanupPolicyXO.getNotes());
        policy.setMode(MODE_DELETE);
        policy.setFormat(cleanupPolicyXO.getFormat());
        policy.setCriteria(this.toCriteriaMap(cleanupPolicyXO));
        return policy;
    }

    private Map<String, String> toCriteriaMap(CleanupPolicyXO cleanupPolicyXO) {
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        CleanupPolicyConfiguration cleanupFormatConfiguration = this.cleanupFormatConfigurationMap.get(cleanupPolicyXO.getFormat());
        if (cleanupFormatConfiguration == null) {
            cleanupFormatConfiguration = this.defaultCleanupFormatConfiguration;
        }
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "regex", cleanupPolicyXO.getCriteriaAssetRegex(), "Asset name regex", cleanupPolicyXO.getFormat());
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "lastBlobUpdated", CleanupPolicyResource.toSeconds(cleanupPolicyXO.getCriteriaLastBlobUpdated()), "Published before", cleanupPolicyXO.getFormat());
        this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "lastDownloaded", CleanupPolicyResource.toSeconds(cleanupPolicyXO.getCriteriaLastDownloaded()), "Last downloaded before", cleanupPolicyXO.getFormat());
        if (cleanupPolicyXO.getCriteriaReleaseType() != null) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "isPrerelease", CleanupPolicyReleaseType.PRERELEASES.equals((Object)cleanupPolicyXO.getCriteriaReleaseType()), "Release type", cleanupPolicyXO.getFormat());
        }
        if (cleanupPolicyXO.getRetain() != null) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "retain", cleanupPolicyXO.getRetain(), "Retain components", cleanupPolicyXO.getFormat());
        }
        if (cleanupPolicyXO.getSortBy() != null) {
            this.handleCriteria(cleanupFormatConfiguration, criteriaMap, "sortBy", cleanupPolicyXO.getSortBy(), "Retain sort by", cleanupPolicyXO.getFormat());
        }
        return criteriaMap;
    }

    private void handleCriteria(CleanupPolicyConfiguration cleanupPolicyConfiguration, Map<String, String> criteriaMap, String key, Object value, String keyText, String format) {
        if (value != null) {
            Boolean val = (Boolean)cleanupPolicyConfiguration.getConfiguration().get(key);
            if (val != null && val.equals(Boolean.TRUE)) {
                criteriaMap.put(key, String.valueOf(value));
            } else {
                throw new BadRequestException(String.format("Specified format %s does not support the '%s' criteria.", format, keyText));
            }
        }
    }

    private static Long toSeconds(Long days) {
        if (days == null) {
            return null;
        }
        return TimeUnit.DAYS.toSeconds(days);
    }
}

