/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.preview;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.ComponentXO;

@Named
@Singleton
public class CSVCleanupPreviewContentWriter
extends ComponentSupport {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Repository repository, Stream<ComponentXO> components, OutputStream outputStream) throws IOException {
        AtomicInteger totalCount;
        block15: {
            this.log.debug("Creating CSV content for the repository {}.", (Object)repository.getName());
            CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(new String[]{"namespace", "name", "version", "path"}).build();
            AtomicInteger flushCount = new AtomicInteger();
            totalCount = new AtomicInteger();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                    try {
                        try (CSVPrinter printer = new CSVPrinter((Appendable)outputStreamWriter, csvFormat);){
                            printer.flush();
                            components.forEach(componentXO -> {
                                try {
                                    for (AssetXO asset : componentXO.getAssets()) {
                                        printer.printRecord(new Object[]{componentXO.getGroup(), componentXO.getName(), componentXO.getVersion(), asset.getPath()});
                                        totalCount.incrementAndGet();
                                    }
                                    if (flushCount.get() == Continuations.BROWSE_LIMIT) {
                                        printer.flush();
                                        flushCount.set(0);
                                    } else {
                                        flushCount.incrementAndGet();
                                    }
                                }
                                catch (IOException e) {
                                    throw new UncheckedIOException(e);
                                }
                            });
                        }
                        if (outputStreamWriter == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (outputStreamWriter == null) throw throwable;
                        outputStreamWriter.close();
                        throw throwable;
                    }
                    outputStreamWriter.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (UncheckedIOException e) {
                this.log.error("Unable to finish writing CSV content for the repository {}. {}.", new Object[]{repository.getName(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                throw new IOException(e);
            }
        }
        this.log.debug("Finished CSV content for the repository {}. Total lines {}.", (Object)repository.getName(), (Object)totalCount.get());
    }
}

