/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.orient.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.elasticsearch.search.SearchContextMissingException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.orient.method.CleanupMethod;
import org.sonatype.nexus.cleanup.internal.orient.search.elasticsearch.OrientCleanupComponentBrowse;
import org.sonatype.nexus.cleanup.service.CleanupService;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.task.DeletionProgress;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientCleanupServiceImpl
extends ComponentSupport
implements CleanupService {
    public static final String CLEANUP_ATTRIBUTES_KEY = "cleanup";
    public static final String CLEANUP_NAME_KEY = "policyName";
    private final RepositoryManager repositoryManager;
    private final OrientCleanupComponentBrowse browseService;
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final CleanupMethod cleanupMethod;
    private final GroupType groupType;
    private int cleanupRetryLimit;

    @Inject
    public OrientCleanupServiceImpl(RepositoryManager repositoryManager, OrientCleanupComponentBrowse browseService, CleanupPolicyStorage cleanupPolicyStorage, CleanupMethod cleanupMethod, GroupType groupType, @Named(value="${nexus.cleanup.retries:-3}") @Named(value="${nexus.cleanup.retries:-3}") int cleanupRetryLimit) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.browseService = (OrientCleanupComponentBrowse)Preconditions.checkNotNull((Object)browseService);
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.cleanupMethod = (CleanupMethod)Preconditions.checkNotNull((Object)cleanupMethod);
        this.groupType = (GroupType)Preconditions.checkNotNull((Object)groupType);
        this.cleanupRetryLimit = cleanupRetryLimit;
    }

    public void cleanup(BooleanSupplier cancelledCheck) {
        AtomicLong totalDeletedCount = new AtomicLong(0L);
        this.repositoryManager.browse().forEach(repository -> {
            if (!cancelledCheck.getAsBoolean() && !repository.getType().equals((Object)this.groupType)) {
                totalDeletedCount.addAndGet(this.cleanup((Repository)repository, cancelledCheck));
            }
        });
        this.log.info("{} components cleaned up across all repositories", (Object)totalDeletedCount.get());
    }

    private Long cleanup(Repository repository, BooleanSupplier cancelledCheck) {
        AtomicLong deletedComponents = new AtomicLong(0L);
        AtomicLong deletedAssets = new AtomicLong(0L);
        UnitOfWork.begin((Supplier)((StorageFacet)repository.facet(StorageFacet.class)).txSupplier());
        try {
            this.findPolicies(repository).forEach(p -> {
                DeletionProgress deletionProgress = this.deleteByPolicy(repository, (CleanupPolicy)p, cancelledCheck);
                deletedComponents.addAndGet(deletionProgress.getComponentCount());
                deletedAssets.addAndGet(deletionProgress.getAssetCount());
                this.log.info("{} components and {} assets cleaned up for repository {} in total", new Object[]{deletedComponents, deletedAssets, repository.getName()});
            });
            Long l = deletedComponents.get();
            return l;
        }
        finally {
            UnitOfWork.end();
        }
    }

    protected DeletionProgress deleteByPolicy(Repository repository, CleanupPolicy policy, BooleanSupplier cancelledCheck) {
        this.log.info("Deleting components in repository {} using policy {}", (Object)repository.getName(), (Object)policy.getName());
        DeletionProgress deletionProgress = new DeletionProgress(this.cleanupRetryLimit);
        if (!policy.getCriteria().isEmpty()) {
            do {
                try {
                    Stream<EntityId> componentsToDelete = this.browseService.browse(policy, repository);
                    DeletionProgress currentProgress = this.cleanupMethod.run(repository, componentsToDelete, cancelledCheck);
                    deletionProgress.update(currentProgress);
                }
                catch (Exception e) {
                    deletionProgress.setAttempts(deletionProgress.getAttempts() + 1);
                    deletionProgress.setFailed(true);
                    if (ExceptionUtils.getRootCause((Throwable)e) instanceof SearchContextMissingException) {
                        this.log.warn("Search scroll timed out, continuing with new scrollId.", (Throwable)(this.log.isDebugEnabled() ? e : null));
                        continue;
                    }
                    this.log.error("Failed to delete components.", (Throwable)e);
                }
            } while (!deletionProgress.isFinished());
            if (deletionProgress.isFailed()) {
                this.log.warn("Deletion attempts exceeded for repository {}", (Object)repository.getName());
            }
            return deletionProgress;
        }
        this.log.info("Policy {} has no criteria and will therefore be ignored (i.e. no components will be deleted)", (Object)policy.getName());
        return deletionProgress;
    }

    private List<CleanupPolicy> findPolicies(Repository repository) {
        ArrayList<CleanupPolicy> cleanupPolicies = new ArrayList<CleanupPolicy>();
        Collection policyNames = Optional.ofNullable(repository.getConfiguration().getAttributes()).map(attributes -> (Map)attributes.get(CLEANUP_ATTRIBUTES_KEY)).map(cleanupAttr -> (Collection)cleanupAttr.get(CLEANUP_NAME_KEY)).orElseGet(Collections::emptySet);
        policyNames.stream().filter(Predicates.notNull()).forEach(policyName -> {
            CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(policyName);
            if (Objects.nonNull(cleanupPolicy)) {
                this.log.debug("Cleanup policy '{}' found for repository {}", policyName, (Object)repository.getName());
                cleanupPolicies.add(cleanupPolicy);
            } else {
                this.log.debug("Cleanup policy '{}' was associated to repository {} but did not exist in storage", policyName, (Object)repository.getName());
            }
        });
        if (cleanupPolicies.isEmpty()) {
            this.log.debug("No cleanup policies found for repository {}", (Object)repository.getName());
        }
        return cleanupPolicies;
    }
}

