/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.orient.search.elasticsearch;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.sonatype.nexus.cleanup.internal.orient.search.elasticsearch.OrientCleanupComponentBrowse;
import org.sonatype.nexus.cleanup.internal.search.elasticsearch.AbstractSearchCleanupComponentBrowse;
import org.sonatype.nexus.cleanup.internal.search.elasticsearch.CriteriaAppender;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.search.query.ElasticSearchQueryService;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientElasticSearchCleanupComponentBrowse
extends AbstractSearchCleanupComponentBrowse
implements OrientCleanupComponentBrowse {
    @Inject
    public OrientElasticSearchCleanupComponentBrowse(Map<String, CriteriaAppender> criteriaAppenders, ElasticSearchQueryService elasticSearchQueryService, MetricRegistry metricRegistry) {
        super(criteriaAppenders, elasticSearchQueryService, metricRegistry);
    }

    @Override
    public PagedResponse<Component> browseByPage(CleanupPolicy policy, Repository repository, QueryOptions options) {
        Preconditions.checkNotNull((Object)options.getStart());
        Preconditions.checkNotNull((Object)options.getLimit());
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        QueryBuilder query = this.convertPolicyToQuery(policy, options);
        this.log.debug("Searching for components to cleanup using policy {}", (Object)policy);
        SearchResponse searchResponse = this.invokeSearchByPage(policy, repository, options, query);
        List components = StreamSupport.stream(searchResponse.getHits().spliterator(), false).map(searchHit -> tx.findComponent((EntityId)new DetachedEntityId(searchHit.getId()))).filter(Objects::nonNull).collect(Collectors.toList());
        return new PagedResponse(searchResponse.getHits().getTotalHits(), components);
    }
}

