/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.datastore.search.criteria;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.datastore.search.criteria.AssetCleanupEvaluator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;

@Named(value="regex")
public class RegexCleanupEvaluator
extends ComponentSupport
implements AssetCleanupEvaluator {
    @Override
    public Predicate<Asset> getPredicate(Repository repository, String value) {
        try {
            Pattern matcher = Pattern.compile(value);
            return asset -> matcher.matcher(asset.path()).matches();
        }
        catch (PatternSyntaxException e) {
            this.log.error("Repository {} has cleanup policies specifying an invalid regular expression: '{}'", (Object)repository.getName(), (Object)value);
            throw new RuntimeException(String.format("Repository %s specifies an invalid regular expression.", repository.getName()), e);
        }
    }
}

