/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.datastore.search.criteria;

import java.util.Map;
import java.util.function.BiPredicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.datastore.search.criteria.ComponentCleanupEvaluator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.utils.PreReleaseEvaluator;

@Named(value="isPrerelease")
public class PrereleaseCleanupEvaluator
extends ComponentSupport
implements ComponentCleanupEvaluator {
    private Map<String, PreReleaseEvaluator> matchers;

    @Inject
    public PrereleaseCleanupEvaluator(Map<String, PreReleaseEvaluator> matchers) {
        this.matchers = matchers;
    }

    @Override
    public BiPredicate<Component, Iterable<Asset>> getPredicate(Repository repository, String value) {
        PreReleaseEvaluator matcher = this.matchers.get(repository.getFormat().getValue());
        BiPredicate<Component, Iterable<Asset>> fn = matcher != null ? (arg_0, arg_1) -> ((PreReleaseEvaluator)matcher).isPreRelease(arg_0, arg_1) : (c, a) -> false;
        boolean isPreRelease = Boolean.parseBoolean(value);
        return isPreRelease ? fn : (c, a) -> !fn.test((Component)c, (Iterable<Asset>)a);
    }
}

