/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.datastore.search.criteria;

import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.cleanup.datastore.search.criteria.ComponentCleanupEvaluator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;

@Named(value="lastBlobUpdated")
public class LastBlobUpdatedCleanupEvaluator
implements ComponentCleanupEvaluator {
    private static final Logger log = LoggerFactory.getLogger(LastBlobUpdatedCleanupEvaluator.class);

    @Override
    public BiPredicate<Component, Iterable<Asset>> getPredicate(Repository repository, String value) {
        OffsetDateTime cutTime = OffsetDateTime.now().minusSeconds(Long.valueOf(value));
        return (component, assets) -> {
            OffsetDateTime max = StreamSupport.stream(assets.spliterator(), false).map(Asset::blob).filter(Optional::isPresent).map(Optional::get).map(AssetBlob::blobCreated).max(OffsetDateTime::compareTo).orElse(null);
            if (max != null) {
                boolean shouldCleanup = max.isBefore(cutTime);
                log.debug("{} cleanup component (assuming other criteria pass) with max blob updated timestamp {} < {}", new Object[]{shouldCleanup ? "Should" : "Should not", max, cutTime});
                return shouldCleanup;
            }
            return false;
        };
    }
}

