/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.content.service;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.elasticsearch.search.SearchContextMissingException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.content.search.CleanupBrowseServiceFactory;
import org.sonatype.nexus.cleanup.content.search.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.internal.method.CleanupMethod;
import org.sonatype.nexus.cleanup.service.CleanupService;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cleanup.CleanupFeatureCheck;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.task.DeletionProgress;
import org.sonatype.nexus.repository.types.GroupType;

@Named
@Singleton
public class CleanupServiceImpl
extends ComponentSupport
implements CleanupService {
    public static final String CLEANUP_ATTRIBUTES_KEY = "cleanup";
    public static final String CLEANUP_NAME_KEY = "policyName";
    public static final String DEFAULT_CLEANUP_BROWSE_NAME = "DataStoreCleanupComponentBrowse";
    public static final String COMPONENT_SET_CLEANUP_BROWSE_NAME = "ComponentSetCleanupComponentBrowse";
    private final RepositoryManager repositoryManager;
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final CleanupMethod cleanupMethod;
    private final GroupType groupType;
    private final int cleanupRetryLimit;
    private final CleanupBrowseServiceFactory browseServiceFactory;
    private final CleanupFeatureCheck cleanupFeatureCheck;

    @Inject
    public CleanupServiceImpl(RepositoryManager repositoryManager, CleanupPolicyStorage cleanupPolicyStorage, CleanupMethod cleanupMethod, GroupType groupType, @Named(value="${nexus.cleanup.retries:-3}") @Named(value="${nexus.cleanup.retries:-3}") int cleanupRetryLimit, CleanupBrowseServiceFactory browseServiceFactory, @Nullable CleanupFeatureCheck cleanupFeatureCheck) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.cleanupMethod = (CleanupMethod)Preconditions.checkNotNull((Object)cleanupMethod);
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.groupType = (GroupType)Preconditions.checkNotNull((Object)groupType);
        this.cleanupRetryLimit = cleanupRetryLimit;
        this.browseServiceFactory = (CleanupBrowseServiceFactory)Preconditions.checkNotNull((Object)browseServiceFactory);
        this.cleanupFeatureCheck = cleanupFeatureCheck;
    }

    public void cleanup(BooleanSupplier cancelledCheck) {
        AtomicLong totalDeletedCount = new AtomicLong(0L);
        this.repositoryManager.browse().forEach(repository -> {
            if (!cancelledCheck.getAsBoolean() && !repository.getType().equals((Object)this.groupType)) {
                totalDeletedCount.addAndGet(this.cleanup((Repository)repository, cancelledCheck));
            }
        });
        this.log.info("{} assets cleaned up across all repositories", (Object)totalDeletedCount.get());
    }

    private Long cleanup(Repository repository, BooleanSupplier cancelledCheck) {
        AtomicLong deleted = new AtomicLong(0L);
        this.findPolicies(repository).forEach(policy -> {
            CleanupComponentBrowse browseService = this.browseServiceFactory.get(repository.getFormat());
            deleted.addAndGet(this.deleteByPolicy(repository, (CleanupPolicy)policy, cancelledCheck, browseService));
            this.log.info("{} assets cleaned up for repository {} in total", (Object)deleted, (Object)repository.getName());
        });
        return deleted.get();
    }

    protected Long deleteByPolicy(Repository repository, CleanupPolicy policy, BooleanSupplier cancelledCheck, CleanupComponentBrowse browseService) {
        this.log.info("Deleting components and assets in repository {} using policy {}", (Object)repository.getName(), (Object)policy.getName());
        DeletionProgress deletionProgress = new DeletionProgress(this.cleanupRetryLimit);
        if (this.hasExclusionCriteria(policy.getCriteria()) && (this.cleanupFeatureCheck == null || !this.cleanupFeatureCheck.isRetainSupported(repository.getFormat().getValue()))) {
            this.log.warn("Skipping policy {} in repository {} since exclusion criteria is not currently supported.", (Object)repository.getName(), (Object)policy.getName());
            return 0L;
        }
        if (!policy.getCriteria().isEmpty()) {
            do {
                try {
                    Stream<FluentComponent> componentsToDelete = browseService.browse(policy, repository);
                    DeletionProgress currentProgress = this.cleanupMethod.run(repository, componentsToDelete, cancelledCheck);
                    deletionProgress.update(currentProgress);
                }
                catch (Exception e) {
                    deletionProgress.setAttempts(deletionProgress.getAttempts() + 1);
                    deletionProgress.setFailed(true);
                    if (ExceptionUtils.getRootCause((Throwable)e) instanceof SearchContextMissingException) {
                        this.log.warn("Search scroll timed out, continuing with new scrollId.", (Throwable)(this.log.isDebugEnabled() ? e : null));
                        continue;
                    }
                    this.log.error("Failed to delete components.", (Throwable)e);
                }
            } while (!deletionProgress.isFinished());
            if (deletionProgress.isFailed()) {
                this.log.warn("Deletion attempts exceeded for repository {}", (Object)repository.getName());
            }
            return deletionProgress.getComponentCount();
        }
        this.log.info("Policy {} has no criteria and will therefore be ignored (i.e. no components will be deleted)", (Object)policy.getName());
        return 0L;
    }

    private boolean hasExclusionCriteria(Map<String, String> criteria) {
        return criteria.containsKey("retain") || criteria.containsKey("sortBy");
    }

    private List<CleanupPolicy> findPolicies(Repository repository) {
        ArrayList<CleanupPolicy> cleanupPolicies = new ArrayList<CleanupPolicy>();
        Collection policyNames = Optional.ofNullable(repository.getConfiguration().getAttributes()).map(attributes -> (Map)attributes.get(CLEANUP_ATTRIBUTES_KEY)).map(cleanupAttr -> (Collection)cleanupAttr.get(CLEANUP_NAME_KEY)).orElseGet(Collections::emptySet);
        policyNames.stream().filter(Predicates.notNull()).forEach(policyName -> {
            CleanupPolicy cleanupPolicy = this.cleanupPolicyStorage.get(policyName);
            if (Objects.nonNull(cleanupPolicy)) {
                this.log.debug("Cleanup policy '{}' found for repository {}", policyName, (Object)repository.getName());
                cleanupPolicies.add(cleanupPolicy);
            } else {
                this.log.debug("Cleanup policy '{}' was associated to repository {} but did not exist in storage", policyName, (Object)repository.getName());
            }
        });
        if (cleanupPolicies.isEmpty()) {
            this.log.debug("No cleanup policies found for repository {}", (Object)repository.getName());
        }
        return cleanupPolicies;
    }
}

