/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.content.service;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.content.search.CleanupBrowseServiceFactory;
import org.sonatype.nexus.cleanup.content.search.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.preview.CleanupPreviewHelper;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyCriteria;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyPreviewXO;
import org.sonatype.nexus.cleanup.storage.CleanupPolicyStorage;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.ComponentXO;
import org.sonatype.nexus.repository.rest.api.DefaultComponentXO;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
@Singleton
public class CleanupPreviewHelperImpl
extends ComponentSupport
implements CleanupPreviewHelper {
    private final CleanupPolicyStorage cleanupPolicyStorage;
    private final Duration previewTimeout;
    private final CleanupBrowseServiceFactory browseServiceFactory;

    @Inject
    public CleanupPreviewHelperImpl(CleanupPolicyStorage cleanupPolicyStorage, @Named(value="${nexus.cleanup.preview.timeout:-60s}") @Named(value="${nexus.cleanup.preview.timeout:-60s}") Duration previewTimeout, CleanupBrowseServiceFactory browseServiceFactory) {
        this.cleanupPolicyStorage = (CleanupPolicyStorage)Preconditions.checkNotNull((Object)cleanupPolicyStorage);
        this.previewTimeout = (Duration)Preconditions.checkNotNull((Object)previewTimeout);
        this.browseServiceFactory = (CleanupBrowseServiceFactory)Preconditions.checkNotNull((Object)browseServiceFactory);
    }

    @Override
    public PagedResponse<ComponentXO> getSearchResults(CleanupPolicyPreviewXO previewXO, Repository repository, QueryOptions queryOptions) {
        CleanupPolicy cleanupPolicy = this.toCleanupPolicy(previewXO);
        return this.searchForComponents(repository, cleanupPolicy, queryOptions);
    }

    @Override
    public Stream<ComponentXO> getSearchResultsStream(CleanupPolicyPreviewXO previewXO, Repository repository, QueryOptions queryOptions) {
        CleanupPolicy cleanupPolicy = this.toCleanupPolicy(previewXO);
        CleanupComponentBrowse browseService = this.browseServiceFactory.getPreviewService();
        Stream<FluentComponent> componentSteam = browseService.browseIncludingAssets(cleanupPolicy, repository);
        return componentSteam.map(component -> CleanupPreviewHelperImpl.convert(component, repository));
    }

    private PagedResponse<ComponentXO> searchForComponents(Repository repository, CleanupPolicy cleanupPolicy, QueryOptions queryOptions) {
        PagedResponse<Component> components = this.browse(cleanupPolicy, repository, queryOptions);
        List componentXOS = ((Collection)components.getData()).stream().map(item -> CleanupPreviewHelperImpl.convert(item, repository)).collect(Collectors.toList());
        return new PagedResponse(components.getTotal(), componentXOS);
    }

    private PagedResponse<Component> browse(CleanupPolicy policy, Repository repository, QueryOptions queryOptions) {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        CompletableFuture<PagedResponse> future = CompletableFuture.supplyAsync(() -> {
            CancelableHelper.set((AtomicBoolean)cancelled);
            try {
                CleanupComponentBrowse browseService = this.browseServiceFactory.getPreviewService();
                PagedResponse<Component> pagedResponse = browseService.browseByPage(policy, repository, queryOptions);
                return pagedResponse;
            }
            finally {
                CancelableHelper.remove();
            }
        });
        try {
            return (PagedResponse)future.get(this.previewTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            cancelled.set(true);
            this.log.debug("Timeout computing preview for cleanup for policy {} in repository {}", new Object[]{policy, repository.getName(), e});
            throw new WebApplicationException(Response.serverError().entity((Object)"A timeout occurred while computing the preview results.").build());
        }
    }

    private CleanupPolicy toCleanupPolicy(CleanupPolicyPreviewXO cleanupPolicyPreviewXO) {
        CleanupPolicy policy = this.cleanupPolicyStorage.newCleanupPolicy();
        policy.setName("preview");
        policy.setCriteria(CleanupPolicyCriteria.toMap((CleanupPolicyCriteria)cleanupPolicyPreviewXO.getCriteria()));
        return policy;
    }

    private static ComponentXO convert(Component component, Repository repository) {
        DefaultComponentXO defaultComponentXO = new DefaultComponentXO();
        defaultComponentXO.setRepository(repository.getName());
        defaultComponentXO.setGroup(component.namespace());
        defaultComponentXO.setName(component.name());
        defaultComponentXO.setVersion(component.version());
        defaultComponentXO.setFormat(repository.getFormat().getValue());
        return defaultComponentXO;
    }

    private static ComponentXO convert(FluentComponent component, Repository repository) {
        ComponentXO componentXO = CleanupPreviewHelperImpl.convert((Component)component, repository);
        List<AssetXO> assetXOS = CleanupPreviewHelperImpl.convert(component.assets());
        componentXO.setAssets(assetXOS);
        return componentXO;
    }

    private static List<AssetXO> convert(Collection<FluentAsset> assets) {
        return assets.stream().map(it -> {
            AssetXO assetXO = new AssetXO();
            assetXO.setPath(it.path());
            return assetXO;
        }).collect(Collectors.toList());
    }
}

