/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.content.search;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.content.search.CleanupComponentBrowse;
import org.sonatype.nexus.cleanup.content.search.ContinuationBrowse;
import org.sonatype.nexus.cleanup.datastore.search.criteria.AssetCleanupEvaluator;
import org.sonatype.nexus.cleanup.datastore.search.criteria.ComponentCleanupEvaluator;
import org.sonatype.nexus.cleanup.storage.CleanupPolicy;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.extdirect.model.PagedResponse;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.query.QueryOptions;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named(value="DataStoreCleanupComponentBrowse")
@Singleton
public class DataStoreCleanupComponentBrowse
extends ComponentSupport
implements CleanupComponentBrowse {
    private final Map<String, AssetCleanupEvaluator> assetCriteria;
    private final Map<String, ComponentCleanupEvaluator> componentCriteria;

    @Inject
    public DataStoreCleanupComponentBrowse(Map<String, ComponentCleanupEvaluator> componentCriteria, Map<String, AssetCleanupEvaluator> assetCriteria) {
        this.componentCriteria = (Map)Preconditions.checkNotNull(componentCriteria);
        this.assetCriteria = (Map)Preconditions.checkNotNull(assetCriteria);
    }

    @Override
    public boolean isApplicableTo(Format format) {
        return true;
    }

    @Override
    public Stream<FluentComponent> browse(CleanupPolicy policy, Repository repository) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull((Object)repository);
        return Continuations.streamOf(this.getComponentBrowser(repository, policy)::browse).filter(this.createComponentFilter(repository, policy));
    }

    @Override
    public Stream<FluentComponent> browseIncludingAssets(CleanupPolicy policy, Repository repository) {
        return Continuations.streamOf((arg_0, arg_1) -> ((FluentComponents)((ContentFacet)repository.facet(ContentFacet.class)).components()).browseEager(arg_0, arg_1)).filter(this.createComponentFilter(repository, policy));
    }

    @Override
    public PagedResponse<Component> browseByPage(CleanupPolicy policy, Repository repository, QueryOptions options) {
        Preconditions.checkNotNull((Object)policy);
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)options.getStart());
        Preconditions.checkNotNull((Object)options.getLimit());
        Predicate<FluentComponent> componentFilter = this.createComponentFilter(repository, policy);
        Optional<Predicate<FluentComponent>> optionsFilter = this.createOptionsFilter(options);
        if (optionsFilter.isPresent()) {
            componentFilter = componentFilter.and(optionsFilter.get());
        }
        List result = Continuations.streamOf(this.getComponentBrowser(repository, policy)::browse, (int)Continuations.BROWSE_LIMIT, (String)options.getLastId()).peek(__ -> {
            boolean bl = CancelableHelper.checkCancellation();
        }).filter(componentFilter).limit(options.getLimit().intValue()).map(Component.class::cast).collect(Collectors.toList());
        return new PagedResponse(-1L, result);
    }

    protected Map<String, String> getFilterableCriteria(Repository repository, CleanupPolicy policy) {
        return policy.getCriteria();
    }

    private Optional<Predicate<FluentComponent>> createOptionsFilter(QueryOptions options) {
        String filter = options.getFilter();
        if (filter != null && filter.trim().length() > 0) {
            Predicate<FluentComponent> optionsFilter = component -> component.name().contains(filter) || component.namespace().contains(filter) || component.version().contains(filter);
            return Optional.of(optionsFilter);
        }
        return Optional.empty();
    }

    private Predicate<FluentComponent> createComponentFilter(Repository repository, CleanupPolicy policy) {
        this.validateCleanupPolicy(policy);
        List componentFilters = this.getFilterableCriteria(repository, policy).entrySet().stream().filter(entry -> this.componentCriteria.containsKey(entry.getKey())).map(entry -> this.componentCriteria.get(entry.getKey()).getPredicate(repository, (String)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
        componentFilters.add(this.createAssetFilter(repository, policy));
        return component -> {
            Iterable assets = component.assets().stream().map(Asset.class::cast).collect(Collectors.toList());
            return componentFilters.stream().allMatch(fn -> fn.test(component, assets));
        };
    }

    private BiPredicate<Component, Iterable<Asset>> createAssetFilter(Repository repository, CleanupPolicy policy) {
        List filters = this.getFilterableCriteria(repository, policy).entrySet().stream().map(entry -> {
            if (!this.assetCriteria.containsKey(entry.getKey())) {
                return null;
            }
            return this.assetCriteria.get(entry.getKey()).getPredicate(repository, (String)entry.getValue());
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return (component, assets) -> StreamSupport.stream(assets.spliterator(), false).anyMatch(asset -> filters.stream().allMatch(p -> p.test(asset)));
    }

    protected void validateCleanupPolicy(CleanupPolicy policy) {
        String missingCriteria = policy.getCriteria().keySet().stream().filter(((Predicate<String>)this.componentCriteria::containsKey).negate()).filter(((Predicate<String>)this.assetCriteria::containsKey).negate()).collect(Collectors.joining(", "));
        if (!missingCriteria.isEmpty()) {
            this.log.error("Failed to create filters for cleanup criteria(s): {}", (Object)missingCriteria);
            this.log.debug("Known criteria are for components: {} and assets: {} ", this.componentCriteria.keySet(), this.assetCriteria.keySet());
            throw new UnsupportedOperationException("Criteria of type(s) [" + missingCriteria + "] not supported");
        }
    }

    protected ContinuationBrowse<FluentComponent> getComponentBrowser(Repository repository, CleanupPolicy policy) {
        return (arg_0, arg_1) -> ((FluentComponents)((ContentFacet)repository.facet(ContentFacet.class)).components()).browse(arg_0, arg_1);
    }
}

