/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.cleanup.internal.content.method;

import com.google.common.collect.Iterators;
import java.util.function.BooleanSupplier;
import java.util.stream.Stream;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.cleanup.internal.method.CleanupMethod;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.task.DeletionProgress;
import org.sonatype.nexus.scheduling.TaskInterruptedException;

@Named
public class DeleteCleanupMethod
extends ComponentSupport
implements CleanupMethod {
    @Override
    public DeletionProgress run(Repository repository, Stream<FluentComponent> components, BooleanSupplier cancelledCheck) {
        ContentMaintenanceFacet maintenance = (ContentMaintenanceFacet)repository.facet(ContentMaintenanceFacet.class);
        DeletionProgress progress = new DeletionProgress();
        Iterators.partition(components.iterator(), (int)Continuations.BROWSE_LIMIT).forEachRemaining(batch -> this.deleteBatch(maintenance, batch.stream(), progress, cancelledCheck));
        return progress;
    }

    private void deleteBatch(ContentMaintenanceFacet maintenance, Stream<FluentComponent> batch, DeletionProgress progress, BooleanSupplier cancelledCheck) {
        if (cancelledCheck.getAsBoolean()) {
            throw new TaskInterruptedException(String.format("Thread '%s' is canceled", Thread.currentThread().getName()), true);
        }
        progress.addComponentCount((long)maintenance.deleteComponents(batch));
    }
}

