/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.SpdxConstants;
import org.spdx.library.model.ModelStorageClassConverter;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.ConjunctiveLicenseSet;
import org.spdx.library.model.license.DisjunctiveLicenseSet;
import org.spdx.library.model.license.ExternalExtractedLicenseInfo;
import org.spdx.library.model.license.ExtractedLicenseInfo;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.LicenseParserException;
import org.spdx.library.model.license.ListedLicenseException;
import org.spdx.library.model.license.OrLaterOperator;
import org.spdx.library.model.license.SimpleLicensingInfo;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.library.model.license.SpdxNoAssertionLicense;
import org.spdx.library.model.license.SpdxNoneLicense;
import org.spdx.library.model.license.WithExceptionOperator;
import org.spdx.storage.IModelStore;

public class LicenseExpressionParser {
    static final String LEFT_PAREN = "(";
    static final String RIGHT_PAREN = ")";
    static final Map<String, Operator> OPERATOR_MAP = new HashMap<String, Operator>();
    public static final String UNINITIALIZED_LICENSE_TEXT = "[Initialized with license Parser.  The actual license text is not available]";

    static AnyLicenseInfo parseLicenseExpression(String expression, IModelStore store, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (expression == null || expression.trim().isEmpty()) {
            throw new LicenseParserException("Empty license expression");
        }
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        String[] tokens = LicenseExpressionParser.tokenizeExpression(expression);
        if (tokens.length == 1 && tokens[0].equals(SpdxConstants.NOASSERTION_VALUE)) {
            return new SpdxNoAssertionLicense();
        }
        if (tokens.length == 1 && tokens[0].equals(SpdxConstants.NONE_VALUE)) {
            return new SpdxNoneLicense();
        }
        try {
            return LicenseExpressionParser.parseLicenseExpression(tokens, store, documentUri, copyManager);
        }
        catch (LicenseParserException ex) {
            throw new LicenseParserException(ex.getMessage() + " License expression: '" + expression + "'", ex);
        }
        catch (EmptyStackException ex) {
            throw new LicenseParserException("Invalid license expression: '" + expression + "' - check that every operator (e.g. AND and OR) has operators and that parenthesis are matched");
        }
    }

    private static String[] tokenizeExpression(String expression) {
        String[] startTokens = expression.split("\\s");
        ArrayList<String> endTokens = new ArrayList<String>();
        for (String token : startTokens) {
            LicenseExpressionParser.processPreToken(token, endTokens);
        }
        return endTokens.toArray(new String[endTokens.size()]);
    }

    private static void processPreToken(String preToken, List<String> tokenList) {
        if (preToken.isEmpty()) {
            return;
        }
        if (preToken.startsWith(LEFT_PAREN)) {
            tokenList.add(LEFT_PAREN);
            LicenseExpressionParser.processPreToken(preToken.substring(1), tokenList);
        } else if (preToken.endsWith(RIGHT_PAREN)) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add(RIGHT_PAREN);
        } else if (preToken.endsWith("+")) {
            LicenseExpressionParser.processPreToken(preToken.substring(0, preToken.length() - 1), tokenList);
            tokenList.add("+");
        } else {
            tokenList.add(preToken);
        }
    }

    private static AnyLicenseInfo parseLicenseExpression(String[] tokens, IModelStore store, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (tokens == null || tokens.length == 0) {
            throw new LicenseParserException("Expected license expression");
        }
        Stack<AnyLicenseInfo> operandStack = new Stack<AnyLicenseInfo>();
        Stack<Operator> operatorStack = new Stack<Operator>();
        int tokenIndex = 0;
        while (tokenIndex < tokens.length) {
            Operator tosOperator;
            String token;
            if (LEFT_PAREN.equals(token = tokens[tokenIndex++])) {
                int rightParenIndex = LicenseExpressionParser.findMatchingParen(tokens, tokenIndex);
                if (rightParenIndex < 0) {
                    throw new LicenseParserException("Missing right parenthesis");
                }
                String[] nestedTokens = Arrays.copyOfRange(tokens, tokenIndex, rightParenIndex);
                operandStack.push(LicenseExpressionParser.parseLicenseExpression(nestedTokens, store, documentUri, copyManager));
                tokenIndex = rightParenIndex + 1;
                continue;
            }
            if (OPERATOR_MAP.get(token) == null) {
                operandStack.push(LicenseExpressionParser.parseSimpleLicenseToken(token, store, documentUri, copyManager));
                continue;
            }
            Operator operator = OPERATOR_MAP.get(token);
            if (operator == Operator.WITH) {
                if (!operatorStack.isEmpty() && Operator.OR_LATER.equals(operatorStack.peek())) {
                    tosOperator = (Operator)((Object)operatorStack.pop());
                    LicenseExpressionParser.evaluateExpression(tosOperator, operandStack, store, documentUri, copyManager);
                }
                if (tokenIndex >= tokens.length) {
                    throw new LicenseParserException("Missing exception clause");
                }
                token = tokens[tokenIndex++];
                ListedLicenseException licenseException = null;
                Optional<Object> exceptionId = Optional.empty();
                if (LicenseInfoFactory.isSpdxListedExceptionId(token)) {
                    exceptionId = LicenseInfoFactory.listedExceptionIdCaseSensitive(token);
                }
                if (exceptionId.isPresent()) {
                    licenseException = LicenseInfoFactory.getListedExceptionById((String)exceptionId.get());
                } else {
                    if (token.startsWith(SpdxConstants.NON_STD_LICENSE_ID_PRENUM)) {
                        throw new LicenseParserException("WITH must be followed by a license exception. " + token + " is a Listed License type.");
                    }
                    licenseException = (ListedLicenseException)SpdxModelFactory.createModelObject(store, documentUri, token, "ListedLicenseException", copyManager);
                }
                AnyLicenseInfo operand = operandStack.pop();
                if (operand == null) {
                    throw new LicenseParserException("Missing license for with clause");
                }
                if (!(operand instanceof SimpleLicensingInfo) && !(operand instanceof OrLaterOperator)) {
                    throw new LicenseParserException("License with exception is not of type SimpleLicensingInfo or OrLaterOperator");
                }
                WithExceptionOperator weo = new WithExceptionOperator(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous, documentUri), copyManager, true);
                weo.setLicense(operand);
                weo.setException(licenseException);
                operandStack.push(weo);
                continue;
            }
            while (!operatorStack.isEmpty() && ((Operator)((Object)operatorStack.peek())).ordinal() <= operator.ordinal()) {
                tosOperator = (Operator)((Object)operatorStack.pop());
                LicenseExpressionParser.evaluateExpression(tosOperator, operandStack, store, documentUri, copyManager);
            }
            operatorStack.push(operator);
        }
        while (!operatorStack.isEmpty()) {
            Operator tosOperator = (Operator)((Object)operatorStack.pop());
            LicenseExpressionParser.evaluateExpression(tosOperator, operandStack, store, documentUri, copyManager);
        }
        AnyLicenseInfo retval = (AnyLicenseInfo)operandStack.pop();
        if (!operandStack.isEmpty()) {
            throw new LicenseParserException("Invalid license expression.  Expecting more operands.");
        }
        return retval;
    }

    private static int findMatchingParen(String[] tokens, int startToken) {
        if (tokens == null) {
            return -1;
        }
        int nestCount = 0;
        for (int i = startToken; i < tokens.length; ++i) {
            if (LEFT_PAREN.equals(tokens[i])) {
                ++nestCount;
                continue;
            }
            if (!RIGHT_PAREN.equals(tokens[i])) continue;
            if (nestCount == 0) {
                return i;
            }
            --nestCount;
        }
        return -1;
    }

    private static AnyLicenseInfo parseSimpleLicenseToken(String token, IModelStore store, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(token, "Token can not be null");
        Objects.requireNonNull(store, "Model store can not be null");
        Objects.requireNonNull(documentUri, "Document URI can not be null");
        if (token.contains(":")) {
            return new ExternalExtractedLicenseInfo(store, documentUri, token, copyManager, true);
        }
        Optional<Object> licenseId = Optional.empty();
        if (LicenseInfoFactory.isSpdxListedLicenseId(token)) {
            licenseId = LicenseInfoFactory.listedLicenseIdCaseSensitive(token);
        }
        if (licenseId.isPresent()) {
            if (!store.exists(documentUri, (String)licenseId.get())) {
                SpdxListedLicense listedLicense = LicenseInfoFactory.getListedLicenseById((String)licenseId.get());
                if (Objects.nonNull(copyManager)) {
                    copyManager.copy(store, documentUri, token, listedLicense.getModelStore(), listedLicense.getDocumentUri(), token, "ListedLicense");
                }
            }
            return (AnyLicenseInfo)ModelStorageClassConverter.storedObjectToModelObject(new TypedValue((String)licenseId.get(), "ListedLicense"), documentUri, store, copyManager);
        }
        Optional<String> caseSensitiveId = store.getCaseSensisitiveId(documentUri, token);
        ExtractedLicenseInfo localLicense = null;
        if (caseSensitiveId.isPresent()) {
            localLicense = new ExtractedLicenseInfo(store, documentUri, caseSensitiveId.get(), copyManager, false);
        } else {
            localLicense = (ExtractedLicenseInfo)SpdxModelFactory.createModelObject(store, documentUri, token, "ExtractedLicensingInfo", copyManager);
            localLicense.setExtractedText(UNINITIALIZED_LICENSE_TEXT);
        }
        return localLicense;
    }

    private static void evaluateExpression(Operator operator, Stack<AnyLicenseInfo> operandStack, IModelStore store, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (operator == Operator.OR_LATER) {
            AnyLicenseInfo license = operandStack.pop();
            if (!(license instanceof SimpleLicensingInfo)) {
                throw new LicenseParserException("Missing license for the '+' or later operator");
            }
            OrLaterOperator olo = new OrLaterOperator(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous, documentUri), copyManager, true);
            olo.setLicense((SimpleLicensingInfo)license);
            operandStack.push(olo);
        } else {
            AnyLicenseInfo operand2 = operandStack.pop();
            AnyLicenseInfo operand1 = operandStack.pop();
            if (operand1 == null || operand2 == null) {
                throw new LicenseParserException("Missing operands for the " + operator.toString() + " operator");
            }
            operandStack.push(LicenseExpressionParser.evaluateBinary(operator, operand1, operand2, store, documentUri, copyManager));
        }
    }

    private static AnyLicenseInfo evaluateBinary(Operator tosOperator, AnyLicenseInfo operand1, AnyLicenseInfo operand2, IModelStore store, String documentUri, ModelCopyManager copyManager) throws InvalidSPDXAnalysisException {
        if (tosOperator == Operator.AND) {
            if (operand1 instanceof ConjunctiveLicenseSet) {
                ((ConjunctiveLicenseSet)operand1).addMember(operand2);
                return operand1;
            }
            ConjunctiveLicenseSet retval = new ConjunctiveLicenseSet(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous, documentUri), copyManager, true);
            retval.addMember(operand1);
            retval.addMember(operand2);
            return retval;
        }
        if (tosOperator == Operator.OR) {
            if (operand1 instanceof DisjunctiveLicenseSet) {
                ((DisjunctiveLicenseSet)operand1).addMember(operand2);
                return operand1;
            }
            DisjunctiveLicenseSet retval = new DisjunctiveLicenseSet(store, documentUri, store.getNextId(IModelStore.IdType.Anonymous, documentUri), copyManager, true);
            retval.addMember(operand1);
            retval.addMember(operand2);
            return retval;
        }
        throw new LicenseParserException("Unknown operator " + tosOperator.toString());
    }

    static {
        OPERATOR_MAP.put("+", Operator.OR_LATER);
        OPERATOR_MAP.put("AND", Operator.AND);
        OPERATOR_MAP.put("OR", Operator.OR);
        OPERATOR_MAP.put("WITH", Operator.WITH);
        OPERATOR_MAP.put("and", Operator.AND);
        OPERATOR_MAP.put("or", Operator.OR);
        OPERATOR_MAP.put("with", Operator.WITH);
    }

    static enum Operator {
        OR_LATER,
        WITH,
        AND,
        OR;

    }
}

