/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.ModelCopyManager;
import org.spdx.library.model.ModelObject;
import org.spdx.library.model.license.AnyLicenseInfo;
import org.spdx.library.model.license.LicenseSet;
import org.spdx.storage.IModelStore;

public class DisjunctiveLicenseSet
extends LicenseSet {
    public DisjunctiveLicenseSet() throws InvalidSPDXAnalysisException {
    }

    public DisjunctiveLicenseSet(String id) throws InvalidSPDXAnalysisException {
        super(id);
    }

    public DisjunctiveLicenseSet(IModelStore modelStore, String documentUri, String id, @Nullable ModelCopyManager copyManager, boolean create) throws InvalidSPDXAnalysisException {
        super(modelStore, documentUri, id, copyManager, create);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        boolean moreThanOne = false;
        try {
            Iterator<AnyLicenseInfo> iter = this.getMembers().iterator();
            while (iter.hasNext()) {
                if (moreThanOne) {
                    sb.append(" OR ");
                }
                moreThanOne = true;
                sb.append(iter.next().toString());
            }
            sb.append(')');
            return sb.toString();
        }
        catch (InvalidSPDXAnalysisException e) {
            return "ERROR RETRIEVING LICENSE SET MEMBERS";
        }
    }

    @Override
    public int hashCode() {
        List<AnyLicenseInfo> allMembers;
        int retval = 41;
        try {
            allMembers = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
        for (AnyLicenseInfo member : allMembers) {
            retval ^= member.hashCode();
        }
        return retval;
    }

    @Override
    public boolean equals(Object o) {
        List<AnyLicenseInfo> myInfos;
        List<AnyLicenseInfo> compInfos;
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisjunctiveLicenseSet)) {
            return false;
        }
        DisjunctiveLicenseSet comp = (DisjunctiveLicenseSet)o;
        try {
            compInfos = comp.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
        try {
            myInfos = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException(e);
        }
        if (compInfos.size() != myInfos.size()) {
            return false;
        }
        for (AnyLicenseInfo myInfo : myInfos) {
            if (compInfos.contains(myInfo)) continue;
            return false;
        }
        return true;
    }

    protected List<AnyLicenseInfo> getFlattenedMembers() throws InvalidSPDXAnalysisException {
        HashSet<AnyLicenseInfo> retval = new HashSet<AnyLicenseInfo>();
        for (AnyLicenseInfo li : this.getMembers()) {
            if (li instanceof DisjunctiveLicenseSet) {
                retval.addAll(((DisjunctiveLicenseSet)li).getFlattenedMembers());
                continue;
            }
            retval.add(li);
        }
        ArrayList<AnyLicenseInfo> retvallist = new ArrayList<AnyLicenseInfo>();
        retvallist.addAll(retval);
        return retvallist;
    }

    @Override
    public boolean equivalent(ModelObject compare) throws InvalidSPDXAnalysisException {
        if (!(compare instanceof DisjunctiveLicenseSet)) {
            return false;
        }
        return this.setsEquivalent((DisjunctiveLicenseSet)compare);
    }

    private boolean setsEquivalent(DisjunctiveLicenseSet compare) throws InvalidSPDXAnalysisException {
        List<AnyLicenseInfo> myInfos;
        List<AnyLicenseInfo> compInfos;
        try {
            compInfos = compare.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting compare license set members", e);
        }
        try {
            myInfos = this.getFlattenedMembers();
        }
        catch (InvalidSPDXAnalysisException e) {
            throw new RuntimeException("Error getting license set members", e);
        }
        if (compInfos.size() != myInfos.size()) {
            return false;
        }
        for (AnyLicenseInfo myInfo : myInfos) {
            if (compInfos.contains(myInfo)) continue;
            boolean found = false;
            for (AnyLicenseInfo compInfo : compInfos) {
                if (!myInfo.equivalent(compInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getType() {
        return "DisjunctiveLicenseSet";
    }
}

