/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.ssl.plugin.internal.ui.CertificateXO;
import com.sonatype.nexus.ssl.plugin.validator.PemCertificate;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.KeystoreException;
import org.sonatype.nexus.ssl.TrustStore;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"ssl_TrustStore"})
class TrustStoreComponent
extends DirectComponentSupport {
    @Inject
    TrustStore trustStore;

    TrustStoreComponent() {
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ssl-truststore:read"})
    List<CertificateXO> read() throws Exception {
        ArrayList<CertificateXO> list = new ArrayList<CertificateXO>();
        for (Certificate certificate : this.trustStore.getTrustedCertificates()) {
            list.add(TrustStoreComponent.asCertificateXO(certificate, true));
        }
        return list;
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:create"})
    @Validate
    CertificateXO create(@NotBlank @PemCertificate String pem) throws Exception {
        Certificate certificate = CertificateUtil.decodePEMFormattedCertificate((String)pem);
        this.trustStore.importTrustCertificate(certificate, CertificateUtil.calculateFingerprint((Certificate)certificate));
        return TrustStoreComponent.asCertificateXO(certificate, true);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:delete"})
    @Validate
    void remove(@NotEmpty String id) throws KeystoreException {
        this.trustStore.removeTrustCertificate(id);
    }

    static CertificateXO asCertificateXO(Certificate certificate, boolean inTrustStore) throws Exception {
        String fingerprint = CertificateUtil.calculateFingerprint((Certificate)certificate);
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            Map subjectRdns = CertificateUtil.getSubjectRdns((X509Certificate)x509Certificate);
            Map issuerRdns = CertificateUtil.getIssuerRdns((X509Certificate)x509Certificate);
            return new CertificateXO(fingerprint, fingerprint, CertificateUtil.serializeCertificateInPEM((Certificate)certificate), x509Certificate.getSerialNumber().toString(), (String)subjectRdns.get("CN"), (String)subjectRdns.get("O"), (String)subjectRdns.get("OU"), (String)issuerRdns.get("CN"), (String)issuerRdns.get("O"), (String)issuerRdns.get("OU"), x509Certificate.getNotBefore().getTime(), x509Certificate.getNotAfter().getTime(), inTrustStore);
        }
        return new CertificateXO(fingerprint, fingerprint, CertificateUtil.serializeCertificateInPEM((Certificate)certificate));
    }
}

