/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.ssl.plugin.internal.ui.CertificateXO;
import com.sonatype.nexus.ssl.plugin.internal.ui.TrustStoreComponent;
import com.sonatype.nexus.ssl.plugin.validator.HostnameOrIpAddress;
import com.sonatype.nexus.ssl.plugin.validator.PemCertificate;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.ssl.CertificateRetriever;
import org.sonatype.nexus.ssl.CertificateUtil;
import org.sonatype.nexus.ssl.TrustStore;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@DirectAction(action={"ssl_Certificate"})
public class CertificateComponent
extends DirectComponentSupport {
    private final TrustStore trustStore;
    private final CertificateRetriever certificateRetriever;

    @Inject
    public CertificateComponent(TrustStore trustStore, CertificateRetriever certificateRetriever) {
        this.trustStore = (TrustStore)Preconditions.checkNotNull((Object)trustStore);
        this.certificateRetriever = (CertificateRetriever)Preconditions.checkNotNull((Object)certificateRetriever);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:read"})
    public CertificateXO retrieveFromHost(@HostnameOrIpAddress @NotEmpty String host, @Nullable Integer port, @Nullable String protocolHint) throws Exception {
        Certificate[] chain;
        try {
            chain = this.certificateRetriever.retrieveCertificates(host, port, protocolHint);
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof UnknownHostException) {
                errorMessage = "Unknown host " + host;
            }
            throw new IOException(errorMessage);
        }
        if (chain == null || chain.length == 0) {
            int actualPort = port == null ? 443 : port;
            throw new IOException(String.format("Could not retrieve an SSL certificate from '%s:%s'", host, actualPort));
        }
        return TrustStoreComponent.asCertificateXO(chain[0], this.isInTrustStore(chain[0]));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @Validate
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ssl-truststore:read"})
    public CertificateXO details(@NotBlank @PemCertificate String pem) throws Exception {
        Certificate certificate = CertificateUtil.decodePEMFormattedCertificate((String)pem);
        return TrustStoreComponent.asCertificateXO(certificate, this.isInTrustStore(certificate));
    }

    boolean isInTrustStore(Certificate certificate) {
        try {
            return this.trustStore.getTrustedCertificate(CertificateUtil.calculateFingerprint((Certificate)certificate)) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

