/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.ssl.plugin.internal.rest;

import com.sonatype.nexus.ssl.plugin.validator.HostnameOrIpAddress;
import com.sonatype.nexus.ssl.plugin.validator.PemCertificate;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;
import org.sonatype.nexus.ssl.ApiCertificate;

@Api(value="Security: certificates")
public interface CertificateApiResourceDoc {
    @ApiOperation(value="Helper method to retrieve certificate details from a remote system.")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to retrieve remote certificate."), @ApiResponse(code=400, message="A certificate could not be retrieved, see the message for details.")})
    public ApiCertificate retrieveCertificate(@ApiParam(value="The remote system's host name") @NotNull @NotEmpty @HostnameOrIpAddress String var1, @ApiParam(value="The port on the remote system to connect to") Integer var2, @ApiParam(value="An optional hint of the protocol to try for the connection") String var3);

    @ApiOperation(value="Retrieve a list of certificates added to the trust store.")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to list certificates in the trust store.")})
    public List<ApiCertificate> getTrustStoreCertificates();

    @ApiOperation(value="Add a certificate to the trust store.")
    @ApiResponses(value={@ApiResponse(code=201, message="The certificate was successfully added.", response=ApiCertificate.class), @ApiResponse(code=409, message="The certificate already exists in the system."), @ApiResponse(code=403, message="Insufficient permissions to add certificate to the trust store.")})
    public Response addCertificate(@ApiParam(value="The certificate to add encoded in PEM format") @NotBlank @PemCertificate String var1);

    @ApiOperation(value="Remove a certificate in the trust store.")
    @ApiResponses(value={@ApiResponse(code=403, message="Insufficient permissions to remove certificate from the trust store")})
    public void removeCertificate(@ApiParam(value="The id of the certificate that should be removed.") String var1);
}

